/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.impl.pipeline.JetEvent;
import com.hazelcast.jet.impl.processor.ProcessorWrapper;
import com.hazelcast.jet.impl.util.WrappingProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.BitSet;
import javax.annotation.Nonnull;

public class FunctionAdapter {
    @Nonnull
    DistributedFunction<?, ?> adaptMapFn(@Nonnull DistributedFunction mapFn) {
        return mapFn;
    }

    @Nonnull
    DistributedBiFunction<?, ?, ?> adaptMapUsingContextFn(@Nonnull DistributedBiFunction mapFn) {
        return mapFn;
    }

    @Nonnull
    DistributedPredicate<?> adaptFilterFn(@Nonnull DistributedPredicate filterFn) {
        return filterFn;
    }

    @Nonnull
    <C, T> DistributedBiPredicate<C, T> adaptFilterUsingContextFn(@Nonnull DistributedBiPredicate<C, T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <R, T> DistributedFunction<Object, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull DistributedFunction<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <C, R, T> DistributedBiFunction<? super C, Object, ? extends Traverser<?>> adaptFlatMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    DistributedFunction<?, ?> adaptToStringFn(@Nonnull DistributedFunction<?, ? extends CharSequence> mapFn) {
        return mapFn;
    }

    @Nonnull
    public JoinClause adaptJoinClause(@Nonnull JoinClause joinClause) {
        return joinClause;
    }

    public <T, T1, R> DistributedBiFunction<Object, T1, Object> adaptHashJoinOutputFn(DistributedBiFunction<T, T1, R> mapToOutputFn) {
        return mapToOutputFn;
    }

    <T, T1, T2, R> DistributedTriFunction<Object, T1, T2, Object> adaptHashJoinOutputFn(DistributedTriFunction<T, T1, T2, R> mapToOutputFn) {
        return mapToOutputFn;
    }

    <R, OUT> WindowResultFunction adaptWindowResultFn(WindowResultFunction<? super R, ? extends OUT> windowResultFn) {
        return windowResultFn;
    }

    <K, R, OUT> KeyedWindowResultFunction adaptKeyedWindowResultFn(KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> keyedWindowResultFn) {
        return keyedWindowResultFn;
    }

    @Nonnull
    public static ProcessorMetaSupplier adaptingMetaSupplier(ProcessorMetaSupplier metaSup, int[] ordinalsToAdapt) {
        return new WrappingProcessorMetaSupplier(metaSup, p -> new AdaptingProcessor((Processor)p, ordinalsToAdapt));
    }

    private static final class AdaptingInbox
    implements Inbox {
        private Inbox wrapped;

        private AdaptingInbox() {
        }

        void setWrappedInbox(@Nonnull Inbox wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Object peek() {
            return AdaptingInbox.unwrapPayload(this.wrapped.peek());
        }

        @Override
        public Object poll() {
            return AdaptingInbox.unwrapPayload(this.wrapped.poll());
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }

        private static Object unwrapPayload(Object jetEvent) {
            return jetEvent != null ? ((JetEvent)jetEvent).payload() : null;
        }
    }

    private static final class AdaptingProcessor
    extends ProcessorWrapper {
        private final AdaptingInbox adaptingInbox = new AdaptingInbox();
        private final BitSet shouldAdaptOrdinal = new BitSet();

        AdaptingProcessor(Processor wrapped, int[] ordinalsToAdapt) {
            super(wrapped);
            for (int ordinal : ordinalsToAdapt) {
                this.shouldAdaptOrdinal.set(ordinal);
            }
        }

        @Override
        public void process(int ordinal, @Nonnull Inbox inbox) {
            Inbox inboxToUse;
            if (this.shouldAdaptOrdinal.get(ordinal)) {
                inboxToUse = this.adaptingInbox;
                this.adaptingInbox.setWrappedInbox(inbox);
            } else {
                inboxToUse = inbox;
            }
            super.process(ordinal, inboxToUse);
        }
    }
}

