/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsByNameCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.ClientJobProxy;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JetClientInstanceImpl
extends AbstractJetInstance {
    private final HazelcastClientInstanceImpl client;
    private SerializationService serializationService;

    public JetClientInstanceImpl(HazelcastClientInstanceImpl hazelcastInstance) {
        super(hazelcastInstance);
        this.client = hazelcastInstance;
        this.serializationService = this.client.getSerializationService();
        ExceptionUtil.registerJetExceptions(hazelcastInstance.getClientExceptionFactory());
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        throw new UnsupportedOperationException("Jet Configuration is not available on the client");
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        long jobId = this.uploadResourcesAndAssignId(config);
        return new ClientJobProxy(this.client, jobId, dag, config);
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        ClientInvocation invocation = new ClientInvocation(this.client, JetGetJobIdsCodec.encodeRequest(), null, JetClientInstanceImpl.masterAddress(this.client.getCluster()));
        return Util.uncheckCall(() -> {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            Set jobs = (Set)this.serializationService.toObject(JetGetJobIdsCodec.decodeResponse((ClientMessage)response).response);
            return jobs.stream().map(jobId -> new ClientJobProxy(this.client, (long)jobId)).collect(Collectors.toList());
        });
    }

    @Override
    public Job getJob(long jobId) {
        try {
            ClientJobProxy job = new ClientJobProxy(this.client, jobId);
            job.getStatus();
            return job;
        }
        catch (Exception e) {
            if (ExceptionUtil.peel(e) instanceof JobNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return this.getJobIdsByName(name).stream().map(jobId -> new ClientJobProxy(this.client, (long)jobId)).collect(Collectors.toList());
    }

    private List<Long> getJobIdsByName(String name) {
        ClientInvocation invocation = new ClientInvocation(this.client, JetGetJobIdsByNameCodec.encodeRequest(name), null, JetClientInstanceImpl.masterAddress(this.client.getCluster()));
        return Util.uncheckCall(() -> {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            List jobs = (List)this.serializationService.toObject(JetGetJobIdsByNameCodec.decodeResponse((ClientMessage)response).response);
            return jobs;
        });
    }

    private static Address masterAddress(Cluster cluster) {
        return ((Member)cluster.getMembers().stream().findFirst().orElseThrow(() -> new IllegalStateException("No members found in cluster"))).getAddress();
    }
}

