/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.net.URL;
import javax.annotation.Nonnull;

public class ResourceConfig
implements Serializable {
    private final URL url;
    private final String id;
    private final boolean isArchive;

    ResourceConfig(@Nonnull URL url, String id, boolean isArchive) {
        Preconditions.checkTrue(isArchive ^ id != null, "Either isArchive == true, or id != null, exclusively");
        this.url = url;
        this.id = id;
        this.isArchive = isArchive;
    }

    ResourceConfig(Class clazz) {
        this.id = clazz.getName().replace('.', '/') + ".class";
        this.url = clazz.getClassLoader().getResource(this.id);
        Preconditions.checkNotNull(this.url, "Couldn't derive URL from class " + clazz);
        this.isArchive = false;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public String toString() {
        return "ResourceConfig{url=" + this.url + ", id='" + this.id + '\'' + ", isArchive=" + this.isArchive + '}';
    }
}

