/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.map.journal.EventJournalMapEvent;
import java.util.AbstractMap;
import java.util.Map;

public final class Util {
    private Util() {
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    public static <K, V> DistributedPredicate<EventJournalMapEvent<K, V>> mapPutEvents() {
        return e -> e.getType() == EntryEventType.ADDED || e.getType() == EntryEventType.UPDATED;
    }

    public static <K, V> DistributedPredicate<EventJournalCacheEvent<K, V>> cachePutEvents() {
        return e -> e.getType() == CacheEventType.CREATED || e.getType() == CacheEventType.UPDATED;
    }

    public static <K, V> DistributedFunction<EventJournalMapEvent<K, V>, Map.Entry<K, V>> mapEventToEntry() {
        return e -> Util.entry(e.getKey(), e.getNewValue());
    }

    public static <K, V> DistributedFunction<EventJournalMapEvent<K, V>, V> mapEventNewValue() {
        return EventJournalMapEvent::getNewValue;
    }

    public static <K, V> DistributedFunction<EventJournalCacheEvent<K, V>, Map.Entry<K, V>> cacheEventToEntry() {
        return e -> Util.entry(e.getKey(), e.getNewValue());
    }
}

