/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheMergeRunnable;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.merge.policy.CacheMergePolicyProvider;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

class CacheSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<ICacheRecordStore> {
    private final CacheService cacheService;
    private final CachePartitionSegment[] segments;
    private final Map<String, CacheConfig> configs;
    private final CacheMergePolicyProvider mergePolicyProvider;

    CacheSplitBrainHandlerService(NodeEngine nodeEngine, Map<String, CacheConfig> configs, CachePartitionSegment[] segments) {
        super(nodeEngine);
        this.configs = configs;
        this.segments = segments;
        this.mergePolicyProvider = new CacheMergePolicyProvider(nodeEngine);
        this.cacheService = (CacheService)nodeEngine.getService("hz:impl:cacheService");
    }

    @Override
    protected Runnable newMergeRunnable(Map<String, Collection<ICacheRecordStore>> collectedStores, Map<String, Collection<ICacheRecordStore>> collectedStoresWithLegacyPolicies, Collection<ICacheRecordStore> backupStores, NodeEngine nodeEngine) {
        return new CacheMergeRunnable(collectedStores, collectedStoresWithLegacyPolicies, backupStores, this, nodeEngine);
    }

    @Override
    public String getDataStructureName(ICacheRecordStore recordStore) {
        return recordStore.getName();
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        CacheConfig cacheConfig = this.configs.get(dataStructureName);
        String mergePolicyName = cacheConfig.getMergePolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    @Override
    protected void onPrepareMergeRunnableEnd(Collection<String> dataStructureNames) {
        for (String cacheName : dataStructureNames) {
            this.cacheService.sendInvalidationEvent(cacheName, null, "<NA>");
        }
    }

    @Override
    protected Collection<Iterator<ICacheRecordStore>> iteratorsOf(int partitionId) {
        return Collections.singletonList(this.segments[partitionId].recordStoreIterator());
    }

    @Override
    protected void destroyStore(ICacheRecordStore store) {
        assert (store.getConfig().getInMemoryFormat() != InMemoryFormat.NATIVE);
        store.destroy();
    }

    public Map<String, CacheConfig> getConfigs() {
        return this.configs;
    }
}

