/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.QueryConstants;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.Extractable;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.getters.MultiResult;
import com.hazelcast.query.impl.getters.ReflectionHelper;
import java.util.Map;

public abstract class QueryableEntry<K, V>
implements Extractable,
Map.Entry<K, V> {
    protected InternalSerializationService serializationService;
    protected Extractors extractors;

    @Override
    public Object getAttributeValue(String attributeName) throws QueryException {
        return this.extractAttributeValue(attributeName);
    }

    @Override
    public AttributeType getAttributeType(String attributeName) throws QueryException {
        return this.extractAttributeType(attributeName);
    }

    @Override
    public abstract V getValue();

    @Override
    public abstract K getKey();

    public abstract Data getKeyData();

    public abstract Data getValueData();

    protected abstract Object getTargetObject(boolean var1);

    TypeConverter getConverter(String attributeName) {
        Object attribute = this.getAttributeValue(attributeName);
        if (attribute == null) {
            return TypeConverters.NULL_CONVERTER;
        }
        AttributeType attributeType = this.extractAttributeType(attributeName, attribute);
        return attributeType == null ? TypeConverters.IDENTITY_CONVERTER : attributeType.getConverter();
    }

    private Object extractAttributeValue(String attributeName) throws QueryException {
        Object result = this.extractAttributeValueIfAttributeQueryConstant(attributeName);
        if (result == null) {
            boolean isKey = QueryableEntry.startsWithKeyConstant(attributeName);
            attributeName = QueryableEntry.getAttributeName(isKey, attributeName);
            Object target = this.getTargetObject(isKey);
            result = QueryableEntry.extractAttributeValueFromTargetObject(this.extractors, this.serializationService, attributeName, target);
        }
        return result;
    }

    private Object extractAttributeValueIfAttributeQueryConstant(String attributeName) {
        if (QueryConstants.KEY_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return this.getKey();
        }
        if (QueryConstants.THIS_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return this.getValue();
        }
        return null;
    }

    static Object extractAttributeValue(Extractors extractors, InternalSerializationService serializationService, String attributeName, Data key, Object value) throws QueryException {
        Object result = QueryableEntry.extractAttributeValueIfAttributeQueryConstant(serializationService, attributeName, key, value);
        if (result == null) {
            boolean isKey = QueryableEntry.startsWithKeyConstant(attributeName);
            attributeName = QueryableEntry.getAttributeName(isKey, attributeName);
            Object target = isKey ? key : value;
            result = QueryableEntry.extractAttributeValueFromTargetObject(extractors, serializationService, attributeName, target);
        }
        return result;
    }

    private static Object extractAttributeValueIfAttributeQueryConstant(InternalSerializationService serializationService, String attributeName, Data key, Object value) {
        if (QueryConstants.KEY_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return serializationService.toObject(key);
        }
        if (QueryConstants.THIS_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return value instanceof Data ? serializationService.toObject(value) : value;
        }
        return null;
    }

    private static boolean startsWithKeyConstant(String attributeName) {
        return attributeName.startsWith(QueryConstants.KEY_ATTRIBUTE_NAME.value());
    }

    private static String getAttributeName(boolean isKey, String attributeName) {
        if (isKey) {
            return attributeName.substring(QueryConstants.KEY_ATTRIBUTE_NAME.value().length() + 1);
        }
        return attributeName;
    }

    private static Object extractAttributeValueFromTargetObject(Extractors extractors, InternalSerializationService serializationService, String attributeName, Object target) {
        return extractors.extract(serializationService, target, attributeName);
    }

    private AttributeType extractAttributeType(String attributeName) {
        AttributeType result = this.extractAttributeTypeIfAttributeQueryConstant(attributeName);
        if (result == null) {
            Object attributeValue = this.extractAttributeValue(attributeName);
            result = this.extractAttributeType(attributeValue);
        }
        return result;
    }

    private AttributeType extractAttributeType(String attributeName, Object attributeValue) {
        AttributeType result = this.extractAttributeTypeIfAttributeQueryConstant(attributeName);
        if (result == null) {
            result = this.extractAttributeType(attributeValue);
        }
        return result;
    }

    private AttributeType extractAttributeTypeIfAttributeQueryConstant(String attributeName) {
        if (QueryConstants.KEY_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getKey().getClass());
        }
        if (QueryConstants.THIS_ATTRIBUTE_NAME.value().equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getValue().getClass());
        }
        return null;
    }

    private AttributeType extractAttributeType(Object attributeValue) {
        if (attributeValue instanceof MultiResult) {
            return this.extractAttributeTypeFromMultiResult((MultiResult)attributeValue);
        }
        return this.extractAttributeTypeFromSingleResult(attributeValue);
    }

    private AttributeType extractAttributeTypeFromSingleResult(Object extractedSingleResult) {
        if (extractedSingleResult == null) {
            return null;
        }
        if (extractedSingleResult instanceof Portable) {
            return AttributeType.PORTABLE;
        }
        return ReflectionHelper.getAttributeType(extractedSingleResult.getClass());
    }

    private AttributeType extractAttributeTypeFromMultiResult(MultiResult extractedMultiResult) {
        Object firstNonNullResult = null;
        for (Object result : extractedMultiResult.getResults()) {
            if (result == null) continue;
            firstNonNullResult = result;
            break;
        }
        if (firstNonNullResult == null) {
            return null;
        }
        return ReflectionHelper.getAttributeType(firstNonNullResult.getClass());
    }
}

