/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.source;

import com.hazelcast.core.IMap;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.stream.impl.pipeline.AbstractSourcePipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.query.Predicate;
import java.util.Map;

public class MapSourcePipe<K, V, E>
extends AbstractSourcePipe<E> {
    private final IMap<K, V> map;
    private final DistributedFunction<Map.Entry<K, V>, E> projectionFn;
    private final Predicate<K, V> predicate;

    public MapSourcePipe(StreamContext context, IMap<K, V> map, Predicate<K, V> predicate, DistributedFunction<Map.Entry<K, V>, E> projectionFn) {
        super(context);
        this.map = map;
        this.predicate = predicate;
        this.projectionFn = projectionFn;
    }

    @Override
    protected ProcessorMetaSupplier getSourceMetaSupplier() {
        if (this.projectionFn != null) {
            return SourceProcessors.readMapP(this.map.getName(), this.predicate, this.projectionFn);
        }
        return SourceProcessors.readMapP(this.map.getName());
    }

    @Override
    protected String getName() {
        return "readMap(" + this.map.getName() + ')';
    }
}

