/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.SortP;
import java.util.Comparator;

class SortPipe<T>
extends AbstractIntermediatePipe<T, T> {
    private final Comparator<? super T> comparator;

    SortPipe(Pipe<T> upstream, StreamContext context, Comparator<? super T> comparator) {
        super(context, true, upstream);
        this.comparator = comparator;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        Comparator comparator = this.comparator;
        Vertex sorter = dag.newVertex(StreamUtil.uniqueVertexName("sort"), () -> new SortP(comparator)).localParallelism(1);
        dag.edge(Edge.between(previous, sorter).distributed().allToOne());
        return sorter;
    }
}

