/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.util.function.Consumer;

class PeekPipe<T>
extends AbstractIntermediatePipe<T, T> {
    private final Consumer<? super T> consumer;

    PeekPipe(StreamContext context, Pipe<T> upstream, Consumer<? super T> consumer) {
        super(context, upstream.isOrdered(), upstream);
        Util.checkSerializable(consumer, "consumer");
        this.consumer = consumer;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        String listName = StreamUtil.uniqueListName();
        IStreamList list = this.context.getJetInstance().getList(listName);
        Vertex previous = this.upstream.buildDAG(dag);
        Vertex writer = dag.newVertex("write-list-" + listName, SinkProcessors.writeListP(listName));
        if (this.upstream.isOrdered()) {
            writer.localParallelism(1);
        }
        dag.edge(Edge.from(previous, 1).to(writer, 0));
        this.context.addStreamListener(() -> {
            list.forEach(this.consumer);
            list.destroy();
        });
        return previous;
    }
}

