/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class SubmitJobOperation
extends AsyncExecutionOperation
implements IdentifiedDataSerializable {
    private Data dag;
    private JobConfig config;
    private volatile CompletableFuture<Boolean> executionFuture;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, Data dag, JobConfig config) {
        super(jobId);
        this.dag = dag;
        this.config = config;
    }

    @Override
    protected void doRun() {
        JetService service = (JetService)this.getService();
        this.executionFuture = service.submitJob(this.jobId, this.dag, this.config);
        this.executionFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, t) -> this.doSendResponse(ExceptionUtil.peel(t))));
    }

    @Override
    public void cancel() {
        if (this.executionFuture != null) {
            this.executionFuture.cancel(true);
        }
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.dag);
        out.writeObject(this.config);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dag = in.readData();
        this.config = (JobConfig)in.readObject();
    }
}

