/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class GetJobStatusOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;
    private boolean retryOnNotFound;
    private JobStatus response;

    public GetJobStatusOperation() {
    }

    public GetJobStatusOperation(long jobId, boolean retryOnNotFound) {
        this.jobId = jobId;
        this.retryOnNotFound = retryOnNotFound;
    }

    @Override
    public void run() throws Exception {
        JetService service = (JetService)this.getService();
        this.response = service.getJobStatus(this.jobId);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return throwable instanceof JobNotFoundException && this.retryOnNotFound ? ExceptionAction.RETRY_INVOCATION : super.onInvocationException(throwable);
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 9;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
        out.writeBoolean(this.retryOnNotFound);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
        this.retryOnNotFound = in.readBoolean();
    }
}

