/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.serialization.SerializationService;
import javax.annotation.Nonnull;

public final class Contexts {
    private Contexts() {
    }

    static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final JetInstance jetInstance;
        private final ILogger logger;
        private final int totalParallelism;
        private final int localParallelism;

        MetaSupplierCtx(JetInstance jetInstance, ILogger logger, int totalParallelism, int localParallelism) {
            this.jetInstance = jetInstance;
            this.logger = logger;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.jetInstance;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }
    }

    static class ProcSupplierCtx
    implements ProcessorSupplier.Context {
        private final JetInstance instance;
        private final int perNodeParallelism;
        private final ILogger logger;

        ProcSupplierCtx(JetInstance instance, ILogger logger, int perNodeParallelism) {
            this.instance = instance;
            this.perNodeParallelism = perNodeParallelism;
            this.logger = logger;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.instance;
        }

        @Override
        public int localParallelism() {
            return this.perNodeParallelism;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }
    }

    public static class ProcCtx
    implements Processor.Context {
        private final JetInstance instance;
        private final ILogger logger;
        private final String vertexName;
        private final int index;
        private final SerializationService serService;
        private final ProcessingGuarantee processingGuarantee;

        public ProcCtx(JetInstance instance, SerializationService serService, ILogger logger, String vertexName, int index, ProcessingGuarantee processingGuarantee) {
            this.instance = instance;
            this.serService = serService;
            this.logger = logger;
            this.vertexName = vertexName;
            this.index = index;
            this.processingGuarantee = processingGuarantee;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.instance;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }

        @Override
        public int globalProcessorIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        public ProcessingGuarantee processingGuarantee() {
            return this.processingGuarantee;
        }

        public SerializationService getSerializationService() {
            return this.serService;
        }
    }
}

