/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.IMap;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.DeflaterOutputStream;

final class ResourceUploader {
    private ResourceUploader() {
    }

    static void uploadMetadata(IMap<String, byte[]> resourcesMap, long jobId, JobConfig jobConfig) {
        HashMap<String, byte[]> tmpMap = new HashMap<String, byte[]>();
        try {
            for (ResourceConfig rc : jobConfig.getResourceConfigs()) {
                if (rc.isArchive()) {
                    ResourceUploader.loadJar(tmpMap, jobId, rc.getUrl());
                    continue;
                }
                ResourceUploader.readStreamAndPutCompressedToMap(tmpMap, jobId, rc.getUrl().openStream(), rc.getId());
            }
            resourcesMap.putAll(tmpMap);
        }
        catch (Throwable e) {
            try {
                resourcesMap.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static void loadJar(Map<String, byte[]> map, long jobId, URL url) throws IOException {
        try (JarInputStream jis = new JarInputStream(new BufferedInputStream(url.openStream()));){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory()) continue;
                ResourceUploader.readStreamAndPutCompressedToMap(map, jobId, jis, jarEntry.getName());
            }
        }
    }

    private static void readStreamAndPutCompressedToMap(Map<String, byte[]> map, long jobId, InputStream in, String resourceId) throws IOException {
        String key = jobId + 47L + resourceId;
        if (map.containsKey(key)) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DeflaterOutputStream compressor = new DeflaterOutputStream(baos);){
            IOUtil.drainTo(in, compressor);
        }
        map.put(key, baos.toByteArray());
    }
}

