/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;

public class JobRecord
implements IdentifiedDataSerializable {
    private long jobId;
    private long creationTime;
    private Data dag;
    private JobConfig config;
    private int quorumSize;

    public JobRecord() {
    }

    public JobRecord(long jobId, long creationTime, Data dag, JobConfig config, int quorumSize) {
        this.jobId = jobId;
        this.creationTime = creationTime;
        this.dag = dag;
        this.config = config;
        this.quorumSize = quorumSize;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Data getDag() {
        return this.dag;
    }

    public JobConfig getConfig() {
        return this.config;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.creationTime);
        out.writeData(this.dag);
        out.writeObject(this.config);
        out.writeInt(this.quorumSize);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.creationTime = in.readLong();
        this.dag = in.readData();
        this.config = (JobConfig)in.readObject();
        this.quorumSize = in.readInt();
    }

    public String toString() {
        return "JobRecord{jobId=" + Util.idToString(this.jobId) + ", creationTime=" + Instant.ofEpochMilli(this.creationTime).atZone(ZoneId.systemDefault()) + ", dag=" + this.dag + ", config=" + this.config + ", quorumSize=" + this.quorumSize + '}';
    }
}

