/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public abstract class AbstractJobImpl
implements Job {
    private final ILogger logger;
    private final CompletableFuture<Void> future = new CompletableFuture();

    AbstractJobImpl(ILogger logger) {
        this.logger = logger;
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    protected abstract Address getMasterAddress();

    protected abstract ICompletableFuture<Void> sendJoinRequest(Address var1);

    protected abstract JobStatus sendJobStatusRequest();

    void init() {
        Address masterAddress = this.getMasterAddress();
        if (masterAddress == null) {
            throw new IllegalStateException("Master address is null");
        }
        ICompletableFuture<Void> invocationFuture = this.sendJoinRequest(masterAddress);
        JobCallback callback = new JobCallback(invocationFuture);
        invocationFuture.andThen(callback);
        this.future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (aVoid, throwable) -> {
            if (throwable instanceof CancellationException) {
                callback.cancel();
            }
        }));
    }

    @Override
    @Nonnull
    public final JobStatus getJobStatus() {
        if (!this.future.isCancelled()) {
            if (this.future.isCompletedExceptionally()) {
                return JobStatus.FAILED;
            }
            if (this.future.isDone()) {
                return JobStatus.COMPLETED;
            }
        }
        return this.sendJobStatusRequest();
    }

    private class JobCallback
    implements ExecutionCallback<Void> {
        private volatile ICompletableFuture<Void> invocationFuture;

        JobCallback(ICompletableFuture<Void> invocationFuture) {
            this.invocationFuture = invocationFuture;
        }

        @Override
        public void onResponse(Void response) {
            AbstractJobImpl.this.future.complete(response);
        }

        @Override
        public synchronized void onFailure(Throwable t) {
            long jobId = AbstractJobImpl.this.getJobId();
            if (this.isSplitBrainMerge(t)) {
                String msg = "Job " + Util.idToString(jobId) + " failed because the cluster is performing split-brain merge";
                AbstractJobImpl.this.logger.fine(msg, t);
                AbstractJobImpl.this.future.completeExceptionally(new CancellationException(msg));
            } else if (this.isRestartable(t)) {
                try {
                    Address masterAddress = AbstractJobImpl.this.getMasterAddress();
                    if (masterAddress == null) {
                        String msg = "Job " + Util.idToString(jobId) + " failed because the cluster is performing " + " split-brain merge and coordinator is not known";
                        AbstractJobImpl.this.logger.fine(msg, t);
                        AbstractJobImpl.this.future.completeExceptionally(new CancellationException(msg));
                        return;
                    }
                    AbstractJobImpl.this.logger.fine("Re-joining to Job " + Util.idToString(jobId) + " after " + t.getClass().getSimpleName());
                    ICompletableFuture<Void> invocationFuture = AbstractJobImpl.this.sendJoinRequest(masterAddress);
                    this.invocationFuture = invocationFuture;
                    invocationFuture.andThen(this);
                    if (AbstractJobImpl.this.future.isCancelled()) {
                        invocationFuture.cancel(true);
                    }
                }
                catch (Exception e) {
                    AbstractJobImpl.this.future.completeExceptionally(e);
                }
            } else {
                AbstractJobImpl.this.future.completeExceptionally(ExceptionUtil.peel(t));
            }
        }

        private boolean isRestartable(Throwable t) {
            Throwable cause = ExceptionUtil.peel(t);
            return cause instanceof MemberLeftException || cause instanceof TargetDisconnectedException || cause instanceof TargetNotMemberException;
        }

        private boolean isSplitBrainMerge(Throwable t) {
            Throwable cause = ExceptionUtil.peel(t);
            return cause instanceof LocalMemberResetException;
        }

        public synchronized void cancel() {
            this.invocationFuture.cancel(true);
        }
    }
}

