/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class DistributedOptional<T>
implements Serializable {
    private static final DistributedOptional<?> EMPTY = new DistributedOptional();
    private final T value;

    private DistributedOptional() {
        this.value = null;
    }

    private DistributedOptional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> DistributedOptional<T> empty() {
        DistributedOptional<?> t = EMPTY;
        return t;
    }

    public static <T> DistributedOptional<T> of(T value) {
        return new DistributedOptional<T>(value);
    }

    public static <T> DistributedOptional<T> ofNullable(T value) {
        return value == null ? DistributedOptional.empty() : DistributedOptional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(DistributedConsumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public DistributedOptional<T> filter(DistributedPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : DistributedOptional.empty();
    }

    public <U> DistributedOptional<U> map(DistributedFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return DistributedOptional.empty();
        }
        return DistributedOptional.ofNullable(mapper.apply(this.value));
    }

    public <U> DistributedOptional<U> flatMap(DistributedFunction<? super T, DistributedOptional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return DistributedOptional.empty();
        }
        return (DistributedOptional)Objects.requireNonNull(mapper.apply(this.value));
    }

    public T orElseGet(DistributedSupplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public <X extends Throwable> T orElseThrow(DistributedSupplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DistributedOptional)) {
            return false;
        }
        DistributedOptional other = (DistributedOptional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

