/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.DistributedIntFunction;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteFileP;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public final class SinkProcessors {
    private SinkProcessors() {
    }

    @Nonnull
    public static ProcessorMetaSupplier writeMapP(@Nonnull String mapName) {
        return HazelcastWriters.writeMapP(mapName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeMapP(mapName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheP(@Nonnull String cacheName) {
        return HazelcastWriters.writeCacheP(cacheName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeCacheP(cacheName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListP(@Nonnull String listName) {
        return HazelcastWriters.writeListP(listName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeRemoteListP(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeListP(listName, clientConfig);
    }

    public static <T> ProcessorMetaSupplier writeSocketP(@Nonnull String host, int port, @Nonnull DistributedFunction<T, String> toStringFn, @Nonnull Charset charset) {
        String charsetName = charset.name();
        return ProcessorMetaSupplier.dontParallelize(SinkProcessors.writeBufferedP(index -> Util.uncheckCall(() -> new BufferedWriter(new OutputStreamWriter(new Socket(host, port).getOutputStream(), charsetName))), (bufferedWriter, item) -> {
            try {
                bufferedWriter.write((String)toStringFn.apply(item));
                bufferedWriter.write(10);
            }
            catch (IOException e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }, bufferedWriter -> Util.uncheckRun(bufferedWriter::flush), bufferedWriter -> Util.uncheckRun(bufferedWriter::close)));
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeFileP(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringFn, @Nonnull Charset charset, boolean append) {
        return WriteFileP.metaSupplier(directoryName, toStringFn, charset.name(), append);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeFileP(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringFn) {
        return SinkProcessors.writeFileP(directoryName, toStringFn, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeFileP(@Nonnull String directoryName) {
        return SinkProcessors.writeFileP(directoryName, Object::toString, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <B, T> ProcessorSupplier writeBufferedP(@Nonnull DistributedIntFunction<B> newBufferFn, @Nonnull DistributedBiConsumer<B, T> addToBufferFn, @Nonnull DistributedConsumer<B> flushBufferFn) {
        return SinkProcessors.writeBufferedP(newBufferFn, addToBufferFn, flushBufferFn, DistributedFunctions.noopConsumer());
    }

    @Nonnull
    public static <B, T> ProcessorSupplier writeBufferedP(@Nonnull DistributedIntFunction<B> newBufferFn, @Nonnull DistributedBiConsumer<B, T> addToBufferFn, @Nonnull DistributedConsumer<B> flushBufferFn, @Nonnull DistributedConsumer<B> disposeBufferFn) {
        return WriteBufferedP.supplier(newBufferFn, addToBufferFn, flushBufferFn, disposeBufferFn);
    }
}

