/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.ComputeStage;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.PipelineImpl;
import com.hazelcast.jet.impl.transform.CoGroupTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CoGroupBuilder<K, E0> {
    private final List<CoGroupClause<?, K>> clauses = new ArrayList();

    CoGroupBuilder(ComputeStage<E0> s, DistributedFunction<? super E0, K> groupKeyFn) {
        this.add(s, groupKeyFn);
    }

    public Tag<E0> tag0() {
        return Tag.tag0();
    }

    public <E> Tag<E> add(ComputeStage<E> stage, DistributedFunction<? super E, K> groupKeyFn) {
        this.clauses.add(new CoGroupClause<E, K>(stage, groupKeyFn));
        return Tag.tag(this.clauses.size() - 1);
    }

    public <A, R> ComputeStage<Tuple2<K, R>> build(AggregateOperation<A, R> aggrOp) {
        List<ComputeStage> upstream = this.clauses.stream().map(CoGroupClause::stage).collect(Collectors.toList());
        CoGroupTransform transform = new CoGroupTransform(this.clauses.stream().map(CoGroupClause::groupKeyFn).collect(Collectors.toList()), aggrOp);
        PipelineImpl pipeline = (PipelineImpl)((CoGroupClause)this.clauses.get(0)).stage.getPipeline();
        return pipeline.attach(upstream, transform);
    }

    private static class CoGroupClause<E, K> {
        private final ComputeStage<E> stage;
        private final DistributedFunction<? super E, K> groupKeyFn;

        CoGroupClause(ComputeStage<E> stage, DistributedFunction<? super E, K> groupKeyFn) {
            this.stage = stage;
            this.groupKeyFn = groupKeyFn;
        }

        ComputeStage<E> stage() {
            return this.stage;
        }

        DistributedFunction<? super E, K> groupKeyFn() {
            return this.groupKeyFn;
        }
    }
}

