/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.source;

import com.hazelcast.core.IList;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.processor.Sources;
import com.hazelcast.jet.stream.impl.pipeline.AbstractSourcePipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

public class ListSourcePipeline<E>
extends AbstractSourcePipeline<E> {
    private final IList<E> list;

    public ListSourcePipeline(StreamContext context, IList<E> list) {
        super(context);
        this.list = list;
    }

    @Override
    protected ProcessorMetaSupplier getSourceMetaSupplier() {
        return Sources.readList(this.list.getName());
    }

    @Override
    protected String getName() {
        return "read-list-" + this.list.getName();
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

