/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.processor.Sinks;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

public class IListReducer<T>
implements DistributedCollector.Reducer<T, IStreamList<T>> {
    private final String listName;

    public IListReducer(String listName) {
        this.listName = listName;
    }

    @Override
    public IStreamList<T> reduce(StreamContext context, Pipeline<? extends T> upstream) {
        IStreamList target = context.getJetInstance().getList(this.listName);
        DAG dag = new DAG();
        Vertex vertex = upstream.buildDAG(dag);
        Vertex writer = dag.newVertex("write-list-" + this.listName, Sinks.writeList(this.listName)).localParallelism(1);
        dag.edge(Edge.between(vertex, writer));
        StreamUtil.executeJob(context, dag);
        return target;
    }
}

