/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Partitioner;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.CombineGroupsP;
import com.hazelcast.jet.stream.impl.processor.GroupAndAccumulateP;
import java.util.stream.Collector;

public class GroupingSinkReducer<T, A, K, D, R>
implements DistributedCollector.Reducer<T, R> {
    private final String sinkName;
    private final DistributedFunction<JetInstance, ? extends R> toDistributedObject;
    private final DistributedFunction<? super T, ? extends K> classifier;
    private final Collector<? super T, A, D> collector;
    private final ProcessorSupplier processorSupplier;

    public GroupingSinkReducer(String sinkName, DistributedFunction<JetInstance, ? extends R> toDistributedObject, DistributedFunction<? super T, ? extends K> classifier, Collector<? super T, A, D> collector, ProcessorSupplier processorSupplier) {
        this.sinkName = sinkName;
        this.toDistributedObject = toDistributedObject;
        this.classifier = classifier;
        this.collector = collector;
        this.processorSupplier = processorSupplier;
    }

    @Override
    public R reduce(StreamContext context, Pipeline<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex previous = upstream.buildDAG(dag);
        Vertex merger = dag.newVertex("group-and-accumulate", () -> new GroupAndAccumulateP(this.classifier, this.collector));
        Vertex combiner = dag.newVertex("combine-groups", () -> new CombineGroupsP(this.collector));
        Vertex writer = dag.newVertex(this.sinkName, this.processorSupplier);
        dag.edge(Edge.between(previous, merger).partitioned(this.classifier::apply, Partitioner.HASH_CODE)).edge(Edge.between(merger, combiner).distributed().partitioned(DistributedFunctions.entryKey())).edge(Edge.between(combiner, writer));
        StreamUtil.executeJob(context, dag);
        return this.toDistributedObject.apply(context.getJetInstance());
    }
}

