/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.processor.Sinks;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.util.function.Consumer;

class PeekPipeline<T>
extends AbstractIntermediatePipeline<T, T> {
    private final Consumer<? super T> consumer;

    PeekPipeline(StreamContext context, Pipeline<T> upstream, Consumer<? super T> consumer) {
        super(context, upstream.isOrdered(), upstream);
        Util.checkSerializable(consumer, "consumer");
        this.consumer = consumer;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        String listName = StreamUtil.uniqueListName();
        IStreamList list = this.context.getJetInstance().getList(listName);
        Vertex previous = this.upstream.buildDAG(dag);
        Vertex writer = dag.newVertex("write-list-" + listName, Sinks.writeList(listName));
        if (this.upstream.isOrdered()) {
            writer.localParallelism(1);
        }
        dag.edge(Edge.from(previous, 1).to(writer, 0));
        this.context.addStreamListener(() -> {
            list.forEach(this.consumer);
            list.destroy();
        });
        return previous;
    }
}

