/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.core.IList;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.distributed.DistributedIntSummaryStatistics;
import com.hazelcast.jet.stream.impl.pipeline.DoublePipeline;
import com.hazelcast.jet.stream.impl.pipeline.LongPipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

class IntPipeline
implements DistributedIntStream {
    private final StreamContext context;
    private final Pipeline<Integer> inner;

    IntPipeline(StreamContext context, Pipeline<Integer> inner) {
        this.context = context;
        this.inner = inner;
    }

    @Override
    public DistributedIntStream filter(IntPredicate predicate) {
        Util.checkSerializable(predicate, "predicate");
        DistributedStream<Integer> filter = this.inner.filter(predicate::test);
        return this.wrap(filter);
    }

    @Override
    public DistributedIntStream map(IntUnaryOperator mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream<Integer> map = this.inner.map(mapper::applyAsInt);
        return this.wrap(map);
    }

    @Override
    public <U> DistributedStream<U> mapToObj(IntFunction<? extends U> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return this.inner.map(mapper::apply);
    }

    @Override
    public DistributedLongStream mapToLong(IntToLongFunction mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream<Long> stream = this.inner.map(mapper::applyAsLong);
        return new LongPipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedDoubleStream mapToDouble(IntToDoubleFunction mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream<Double> stream = this.inner.map(mapper::applyAsDouble);
        return new DoublePipeline(this.context, (Pipeline)stream);
    }

    @Override
    public DistributedIntStream flatMap(IntFunction<? extends IntStream> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return this.wrap(this.inner.flatMap((? super T n) -> ((IntStream)mapper.apply((int)n)).boxed()));
    }

    @Override
    public DistributedIntStream distinct() {
        return this.wrap(this.inner.distinct());
    }

    @Override
    public DistributedIntStream sorted() {
        return this.wrap(this.inner.sorted());
    }

    @Override
    public DistributedIntStream peek(IntConsumer action) {
        return this.wrap(this.inner.peek(action::accept));
    }

    @Override
    public DistributedIntStream limit(long maxSize) {
        return this.wrap(this.inner.limit(maxSize));
    }

    @Override
    public DistributedIntStream skip(long n) {
        return this.wrap(this.inner.skip(n));
    }

    @Override
    public void forEach(IntConsumer action) {
        this.inner.forEach(action::accept);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.inner.forEachOrdered(action::accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray() {
        IList list = this.inner.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        try {
            int[] array = new int[list.size()];
            int index = 0;
            for (Integer i : list) {
                array[index++] = i;
            }
            Object object = array;
            return object;
        }
        finally {
            list.destroy();
        }
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return this.inner.reduce(Integer.valueOf(identity), op::applyAsInt);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        Optional result = this.inner.reduce(op::applyAsInt);
        return result.isPresent() ? OptionalInt.of((Integer)result.get()) : OptionalInt.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        DistributedBiConsumer<Object, Integer> boxedAccumulator = accumulator::accept;
        return (R)this.inner.collect(supplier, boxedAccumulator, combiner);
    }

    @Override
    public int sum() {
        return this.inner.reduce(Integer.valueOf(0), (a, b) -> a + b);
    }

    @Override
    public OptionalInt min() {
        return IntPipeline.toOptionalInt(this.inner.min(DistributedComparator.naturalOrder()));
    }

    @Override
    public OptionalInt max() {
        return IntPipeline.toOptionalInt(this.inner.max(DistributedComparator.naturalOrder()));
    }

    @Override
    public long count() {
        return this.inner.count();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = this.collect(() -> new long[2], (ll, i) -> {
            ll[0] = ll[0] + 1L;
            ll[1] = ll[1] + (long)i;
        }, (R ll, R rr) -> {
            ll[0] = ll[0] + rr[0];
            ll[1] = ll[1] + rr[1];
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.collect(DistributedIntSummaryStatistics::new, IntSummaryStatistics::accept, IntSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.inner.anyMatch(predicate::test);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.inner.allMatch(predicate::test);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return this.inner.noneMatch(predicate::test);
    }

    @Override
    public OptionalInt findFirst() {
        return IntPipeline.toOptionalInt(this.inner.findFirst());
    }

    @Override
    public OptionalInt findAny() {
        return IntPipeline.toOptionalInt(this.inner.findAny());
    }

    @Override
    public DistributedLongStream asLongStream() {
        return this.mapToLong(m -> m);
    }

    @Override
    public DistributedDoubleStream asDoubleStream() {
        return this.mapToDouble(m -> m);
    }

    @Override
    public DistributedStream<Integer> boxed() {
        return this.inner;
    }

    @Override
    public DistributedIntStream sequential() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedIntStream parallel() {
        return this;
    }

    @Override
    public DistributedIntStream unordered() {
        return this.wrap((Stream<Integer>)this.inner.unordered());
    }

    @Override
    public DistributedIntStream onClose(Runnable closeHandler) {
        return this.wrap((Stream)this.inner.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        final Iterator iterator = this.inner.iterator();
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return (Integer)iterator.next();
            }
        };
    }

    @Override
    public Spliterator.OfInt spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isParallel() {
        return this.inner.isParallel();
    }

    @Override
    public DistributedIntStream configure(JobConfig jobConfig) {
        return this.wrap(this.inner.configure(jobConfig));
    }

    private DistributedIntStream wrap(Stream<Integer> pipeline) {
        return new IntPipeline(this.context, (Pipeline)pipeline);
    }

    private static OptionalInt toOptionalInt(Optional<Integer> optional) {
        return optional.isPresent() ? OptionalInt.of(optional.get()) : OptionalInt.empty();
    }
}

