/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.util.UuidUtil;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;

public final class StreamUtil {
    private static final String LIST_PREFIX = "__jet_list_";
    private static final int UUID_TRUNCATE_INDEX = 24;

    private StreamUtil() {
    }

    public static String uniqueListName() {
        return LIST_PREFIX + StreamUtil.randomName();
    }

    public static String uniqueVertexName(String name) {
        return name + '-' + UuidUtil.newUnsecureUUID().toString().substring(24);
    }

    public static void executeJob(StreamContext context, DAG dag) {
        JobConfig jobConfig = context.getJobConfig() != null ? context.getJobConfig() : new JobConfig();
        Job job = context.getJetInstance().newJob(dag, jobConfig);
        try {
            job.execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
        context.getStreamListeners().forEach(Runnable::run);
    }

    public static void setPrivateField(Object instance, Class<?> clazz, String name, Object val) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        field.set(instance, val);
    }

    private static String randomName() {
        return UuidUtil.newUnsecureUUID().toString();
    }
}

