/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.cache.ICache;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedOptional;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToIntFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.processor.Sinks;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.IStreamCache;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.IStreamMap;
import com.hazelcast.jet.stream.impl.distributed.DistributedDoubleSummaryStatistics;
import com.hazelcast.jet.stream.impl.distributed.DistributedIntSummaryStatistics;
import com.hazelcast.jet.stream.impl.distributed.DistributedLongSummaryStatistics;
import com.hazelcast.jet.stream.impl.reducers.DistributedCollectorImpl;
import com.hazelcast.jet.stream.impl.reducers.DistributedStringJoiner;
import com.hazelcast.jet.stream.impl.reducers.GroupingSinkReducer;
import com.hazelcast.jet.stream.impl.reducers.IListReducer;
import com.hazelcast.jet.stream.impl.reducers.MergingSinkReducer;
import com.hazelcast.jet.stream.impl.reducers.SinkReducer;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public abstract class DistributedCollectors {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    static <T> DistributedSupplier<T[]> boxSupplier(T identity) {
        return () -> new Object[]{identity};
    }

    public static <T, C extends Collection<T>> DistributedCollector<T, ?, C> toCollection(DistributedSupplier<C> collectionFactory) {
        return new DistributedCollectorImpl(collectionFactory, Collection::add, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, CH_ID);
    }

    public static <T> DistributedCollector<T, ?, List<T>> toList() {
        return new DistributedCollectorImpl(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <T> DistributedCollector<T, ?, Set<T>> toSet() {
        return new DistributedCollectorImpl(HashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_UNORDERED_ID);
    }

    public static DistributedCollector<CharSequence, ?, String> joining() {
        return new DistributedCollectorImpl<CharSequence, StringBuilder, String>(StringBuilder::new, StringBuilder::append, (r1, r2) -> {
            r1.append((CharSequence)r2);
            return r1;
        }, StringBuilder::toString, CH_NOID);
    }

    public static DistributedCollector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return DistributedCollectors.joining(delimiter, "", "");
    }

    public static DistributedCollector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new DistributedCollectorImpl<CharSequence, DistributedStringJoiner, String>(() -> new DistributedStringJoiner(delimiter, prefix, suffix), DistributedStringJoiner::add, DistributedStringJoiner::merge, DistributedStringJoiner::toString, CH_NOID);
    }

    public static <T, U, A, R> DistributedCollector<T, ?, R> mapping(DistributedFunction<? super T, ? extends U> mapper, DistributedCollector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new DistributedCollectorImpl((DistributedSupplier<Object>)downstream.supplier(), (arg_0, arg_1) -> DistributedCollectors.lambda$mapping$290eac4$1((DistributedBiConsumer)downstreamAccumulator, mapper, arg_0, arg_1), (DistributedBinaryOperator<Object>)downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, A, R, RR> DistributedCollector<T, A, RR> collectingAndThen(DistributedCollector<T, A, R> downstream, DistributedFunction<R, RR> finisher) {
        Set<Collector.Characteristics> characteristics = downstream.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (characteristics.size() == 1) {
                characteristics = CH_NOID;
            } else {
                characteristics = EnumSet.copyOf(characteristics);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                characteristics = Collections.unmodifiableSet(characteristics);
            }
        }
        return new DistributedCollectorImpl(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), characteristics);
    }

    public static <T> DistributedCollector<T, ?, Long> counting() {
        return DistributedCollectors.reducing(0L, e -> 1L, Long::sum);
    }

    public static <T> DistributedCollector<T, ?, DistributedOptional<T>> minBy(DistributedComparator<? super T> comparator) {
        return DistributedCollectors.reducing(DistributedBinaryOperator.minBy(comparator));
    }

    public static <T> DistributedCollector<T, ?, DistributedOptional<T>> maxBy(DistributedComparator<? super T> comparator) {
        return DistributedCollectors.reducing(DistributedBinaryOperator.maxBy(comparator));
    }

    public static <T> DistributedCollector<T, ?, Integer> summingInt(DistributedToIntFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, int[], Integer>(() -> new int[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsInt(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, Long> summingLong(DistributedToLongFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, long[], Long>(() -> new long[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, Double> summingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, double[], Double>(() -> new double[3], (a, t) -> {
            DistributedCollectors.sumWithCompensation(a, mapper.applyAsDouble(t));
            a[2] = a[2] + mapper.applyAsDouble(t);
        }, (a, b) -> {
            DistributedCollectors.sumWithCompensation(a, b[0]);
            a[2] = a[2] + b[2];
            return DistributedCollectors.sumWithCompensation(a, b[1]);
        }, a -> DistributedCollectors.computeFinalSum(a), CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, Double> averagingInt(DistributedToIntFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + (long)mapper.applyAsInt(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, Double> averagingLong(DistributedToLongFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, Double> averagingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return new DistributedCollectorImpl<Object, double[], Double>(() -> new double[4], (a, t) -> {
            DistributedCollectors.sumWithCompensation(a, mapper.applyAsDouble(t));
            a[2] = a[2] + 1.0;
            a[3] = a[3] + mapper.applyAsDouble(t);
        }, (a, b) -> {
            DistributedCollectors.sumWithCompensation(a, b[0]);
            DistributedCollectors.sumWithCompensation(a, b[1]);
            a[2] = a[2] + b[2];
            a[3] = a[3] + b[3];
            return a;
        }, a -> a[2] == 0.0 ? 0.0 : DistributedCollectors.computeFinalSum(a) / a[2], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, T> reducing(T identity, DistributedBinaryOperator<T> op) {
        return new DistributedCollectorImpl<Object, Object[], Object>(DistributedCollectors.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], t);
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> DistributedCollector<T, ?, DistributedOptional<T>> reducing(DistributedBinaryOperator<T> op) {
        class OptionalBox
        implements DistributedConsumer<T> {
            T value;
            boolean present;
            final /* synthetic */ DistributedBinaryOperator val$op;

            OptionalBox(DistributedBinaryOperator distributedBinaryOperator) {
                this.val$op = distributedBinaryOperator;
            }

            @Override
            public void accept(T t) {
                if (this.present) {
                    this.value = this.val$op.apply(this.value, t);
                } else {
                    this.value = t;
                    this.present = true;
                }
            }
        }
        return new DistributedCollectorImpl<Object, OptionalBox, DistributedOptional>(() -> new OptionalBox(op), OptionalBox::accept, (a, b) -> {
            if (b.present) {
                a.accept(b.value);
            }
            return a;
        }, a -> DistributedOptional.ofNullable(a.value), CH_NOID);
    }

    public static <T, U> DistributedCollector<T, ?, U> reducing(U identity, DistributedFunction<? super T, ? extends U> mapper, DistributedBinaryOperator<U> op) {
        return new DistributedCollectorImpl<Object, Object[], Object>(DistributedCollectors.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], mapper.apply(t));
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T, K> DistributedCollector<T, ?, Map<K, List<T>>> groupingBy(DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingBy(classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector<T, ?, Map<K, D>> groupingBy(DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return DistributedCollectors.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> DistributedCollector<T, ?, M> groupingBy(DistributedFunction<? super T, ? extends K> classifier, DistributedSupplier<M> mapFactory, DistributedCollector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        DistributedBiConsumer<Map, Object> accumulator = (arg_0, arg_1) -> DistributedCollectors.lambda$groupingBy$7cd4c761$1(classifier, (DistributedSupplier)downstreamSupplier, (DistributedBiConsumer)downstreamAccumulator, arg_0, arg_1);
        DistributedBinaryOperator<M> merger = DistributedCollectors.mapMerger(downstream.combiner());
        DistributedSupplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new DistributedCollectorImpl(mangledFactory, accumulator, merger, CH_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        DistributedFunction<Map, Map> finisher = arg_0 -> DistributedCollectors.lambda$groupingBy$3ec9811f$1((DistributedFunction)downstreamFinisher, arg_0);
        return new DistributedCollectorImpl<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(DistributedPredicate<? super T> predicate) {
        return DistributedCollectors.partitioningBy(predicate, DistributedCollectors.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(DistributedPredicate<? super T> predicate, DistributedCollector<? super T, A, D> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        DistributedBiConsumer<Partition, Object> accumulator = (arg_0, arg_1) -> DistributedCollectors.lambda$partitioningBy$8025aa7$1((DistributedBiConsumer)downstreamAccumulator, predicate, arg_0, arg_1);
        BinaryOperator op = downstream.combiner();
        DistributedBinaryOperator merger = (arg_0, arg_1) -> DistributedCollectors.lambda$partitioningBy$6ff19313$1((DistributedBinaryOperator)op, arg_0, arg_1);
        DistributedSupplier<Partition> supplier = () -> new Partition(downstream.supplier().get(), downstream.supplier().get());
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new DistributedCollectorImpl(supplier, accumulator, merger, CH_ID);
        }
        DistributedFunction<Partition, Map> finisher = par -> new Partition(downstream.finisher().apply(par.forTrue), downstream.finisher().apply(par.forFalse));
        return new DistributedCollectorImpl<Object, Partition, Map>(supplier, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K, U> DistributedCollector<T, ?, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return DistributedCollectors.toMap(keyMapper, valueMapper, DistributedCollectors.throwingMerger(), HashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return DistributedCollectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> DistributedCollector<T, ?, M> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction, DistributedSupplier<M> mapSupplier) {
        DistributedBiConsumer<Map, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new DistributedCollectorImpl(mapSupplier, accumulator, DistributedCollectors.mapMerger(mergeFunction), CH_ID);
    }

    public static <T> DistributedCollector<T, ?, IntSummaryStatistics> summarizingInt(DistributedToIntFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedIntSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsInt(t)), (l, r) -> {
            l.combine((IntSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> DistributedCollector<T, ?, LongSummaryStatistics> summarizingLong(DistributedToLongFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedLongSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsLong(t)), (l, r) -> {
            l.combine((LongSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> DistributedCollector<T, ?, DoubleSummaryStatistics> summarizingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedDoubleSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsDouble(t)), (l, r) -> {
            l.combine((DoubleSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    private static <K, V, M extends Map<K, V>> DistributedBinaryOperator<M> mapMerger(DistributedBinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static <T> DistributedBinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    static <I, R> DistributedFunction<I, R> castingIdentity() {
        return i -> i;
    }

    static double[] sumWithCompensation(double[] intermediateSum, double value) {
        double tmp = value - intermediateSum[1];
        double sum = intermediateSum[0];
        double velvel = sum + tmp;
        intermediateSum[1] = velvel - sum - tmp;
        intermediateSum[0] = velvel;
        return intermediateSum;
    }

    static double computeFinalSum(double[] summands) {
        double tmp = summands[0] + summands[1];
        double simpleSum = summands[summands.length - 1];
        if (Double.isNaN(tmp) && Double.isInfinite(simpleSum)) {
            return simpleSum;
        }
        return tmp;
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IStreamMap<K, U>> toIMap(String mapName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return new SinkReducer<T, K, U, IStreamMap>("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), keyMapper, valueMapper, Sinks.writeMap(mapName));
    }

    public static <K, U> DistributedCollector.Reducer<Map.Entry<K, U>, IStreamMap<K, U>> toIMap(String mapName) {
        return DistributedCollectors.toIMap(mapName, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IStreamMap<K, U>> toIMap(String mapName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return new MergingSinkReducer<T, K, U, IStreamMap>("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), keyMapper, valueMapper, mergeFunction, Sinks.writeMap(mapName));
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IStreamCache<K, U>> toICache(String cacheName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return new SinkReducer("write-cache-" + cacheName, CacheGetter.getCacheF(cacheName), keyMapper, valueMapper, Sinks.writeCache(cacheName));
    }

    public static <K, U> DistributedCollector.Reducer<Map.Entry<K, U>, IStreamCache<K, U>> toICache(String cacheName) {
        return DistributedCollectors.toICache(cacheName, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IStreamCache<K, U>> toICache(String cacheName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return new MergingSinkReducer("write-cache-" + cacheName, CacheGetter.getCacheF(cacheName), keyMapper, valueMapper, mergeFunction, Sinks.writeCache(cacheName));
    }

    public static <T> DistributedCollector.Reducer<T, IStreamList<T>> toIList(String listName) {
        return new IListReducer(listName);
    }

    public static <T, K> DistributedCollector.Reducer<T, IMap<K, List<T>>> groupingByToIMap(String mapName, DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingByToIMap(mapName, classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector.Reducer<T, IMap<K, D>> groupingByToIMap(String mapName, DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return new GroupingSinkReducer<T, A, K, D, IMap>("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), classifier, downstream, Sinks.writeMap(mapName));
    }

    public static <T, K> DistributedCollector.Reducer<T, ICache<K, List<T>>> groupingByToICache(String cacheName, DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingByToICache(cacheName, classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector.Reducer<T, ICache<K, D>> groupingByToICache(String cacheName, DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return new GroupingSinkReducer("write-cache-" + cacheName, CacheGetter.getCacheF(cacheName), classifier, downstream, Sinks.writeCache(cacheName));
    }

    private static /* synthetic */ Partition lambda$partitioningBy$6ff19313$1(DistributedBinaryOperator op, Partition left, Partition right) {
        return new Partition(op.apply(left.forTrue, right.forTrue), op.apply(left.forFalse, right.forFalse));
    }

    private static /* synthetic */ void lambda$partitioningBy$8025aa7$1(DistributedBiConsumer downstreamAccumulator, DistributedPredicate predicate, Partition result, Object t) {
        downstreamAccumulator.accept(predicate.test(t) ? result.forTrue : result.forFalse, t);
    }

    private static /* synthetic */ Map lambda$groupingBy$3ec9811f$1(DistributedFunction downstreamFinisher, Map intermediate) {
        intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
        Map castResult = intermediate;
        return castResult;
    }

    private static /* synthetic */ void lambda$groupingBy$7cd4c761$1(DistributedFunction classifier, DistributedSupplier downstreamSupplier, DistributedBiConsumer downstreamAccumulator, Map m, Object t) {
        Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
        Object container = m.computeIfAbsent(key, k -> downstreamSupplier.get());
        downstreamAccumulator.accept(container, t);
    }

    private static /* synthetic */ void lambda$mapping$290eac4$1(DistributedBiConsumer downstreamAccumulator, DistributedFunction mapper, Object r, Object t) {
        downstreamAccumulator.accept(r, mapper.apply(t));
    }

    private static class CacheGetter {
        private CacheGetter() {
        }

        private static <K, V> DistributedFunction<JetInstance, IStreamCache<K, V>> getCacheF(String name) {
            return instance -> instance.getCache(name);
        }
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T>,
    Serializable {
        final T forTrue;
        final T forFalse;

        Partition(T forTrue, T forFalse) {
            this.forTrue = forTrue;
            this.forFalse = forFalse;
        }

        @Override
        @Nonnull
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                @Nonnull
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    Map.Entry falseEntry = Util.entry(false, forFalse);
                    Map.Entry trueEntry = Util.entry(true, forTrue);
                    return Arrays.asList(falseEntry, trueEntry).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }
    }
}

