/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.IStreamCache;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.IStreamMap;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.jar.JarFile;

public final class JetBootstrap {
    private static final Supplier<JetBootstrap> SUPPLIER = Util.memoizeConcurrent(() -> new JetBootstrap(Jet.newJetClient()));
    private static String jarPathname;
    private final JetInstance instance;

    private JetBootstrap(JetInstance instance) {
        this.instance = new InstanceProxy(instance);
    }

    public static void main(String[] args) throws Exception {
        int argLength = 1;
        if (args.length < argLength) {
            JetBootstrap.error(JetBootstrap.class.getSimpleName() + ".main() must be called with the JAR filename as the first argument");
        }
        jarPathname = args[0];
        try (JarFile jarFile = new JarFile(jarPathname);){
            String mainClass;
            if (jarFile.getManifest() == null) {
                JetBootstrap.error("No manifest file in " + jarPathname);
            }
            if ((mainClass = jarFile.getManifest().getMainAttributes().getValue("Main-Class")) == null) {
                JetBootstrap.error("No Main-Class found in manifest");
            }
            String[] jobArgs = new String[args.length - argLength];
            System.arraycopy(args, argLength, jobArgs, 0, args.length - argLength);
            ClassLoader classLoader = JetBootstrap.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass(mainClass);
            Method main = clazz.getDeclaredMethod("main", String[].class);
            int mods = main.getModifiers();
            if ((mods & 1) == 0 || (mods & 8) == 0) {
                JetBootstrap.error("Class " + clazz.getName() + " has a main(String[] args) method which is not public static");
            }
            main.invoke(null, new Object[]{jobArgs});
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static JetInstance getInstance() {
        return JetBootstrap.SUPPLIER.get().instance;
    }

    private static class InstanceProxy
    implements JetInstance {
        private final JetInstance instance;

        InstanceProxy(JetInstance instance) {
            this.instance = instance;
        }

        @Override
        public String getName() {
            return this.instance.getName();
        }

        @Override
        public HazelcastInstance getHazelcastInstance() {
            return this.instance.getHazelcastInstance();
        }

        @Override
        public Cluster getCluster() {
            return this.instance.getCluster();
        }

        @Override
        public JetConfig getConfig() {
            return this.instance.getConfig();
        }

        @Override
        public Job newJob(DAG dag) {
            return this.newJob(dag, new JobConfig());
        }

        @Override
        public Job newJob(DAG dag, JobConfig config) {
            if (jarPathname != null) {
                config.addJar(jarPathname);
            }
            return this.instance.newJob(dag, config);
        }

        @Override
        public <K, V> IStreamMap<K, V> getMap(String name) {
            return this.instance.getMap(name);
        }

        @Override
        public <K, V> IStreamCache<K, V> getCache(String name) {
            return this.instance.getCache(name);
        }

        @Override
        public <E> IStreamList<E> getList(String name) {
            return this.instance.getList(name);
        }

        @Override
        public void shutdown() {
            this.instance.shutdown();
        }
    }
}

