/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.processor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.connector.ReadFilesP;
import com.hazelcast.jet.impl.connector.ReadIListP;
import com.hazelcast.jet.impl.connector.ReadWithPartitionIteratorP;
import com.hazelcast.jet.impl.connector.StreamFilesP;
import com.hazelcast.jet.impl.connector.StreamSocketP;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public final class Sources {
    private Sources() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readMap(@Nonnull String mapName) {
        return ReadWithPartitionIteratorP.readMap(mapName);
    }

    @Nonnull
    public static ProcessorMetaSupplier readMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readMap(mapName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier readCache(@Nonnull String cacheName) {
        return ReadWithPartitionIteratorP.readCache(cacheName);
    }

    @Nonnull
    public static ProcessorMetaSupplier readCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readCache(cacheName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier readList(@Nonnull String listName) {
        return ReadIListP.supplier(listName);
    }

    @Nonnull
    public static ProcessorMetaSupplier readList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return ReadIListP.supplier(listName, clientConfig);
    }

    @Nonnull
    public static DistributedSupplier<Processor> streamSocket(@Nonnull String host, int port) {
        return Sources.streamSocket(host, port, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static DistributedSupplier<Processor> streamSocket(@Nonnull String host, int port, @Nonnull Charset charset) {
        return StreamSocketP.supplier(host, port, charset.name());
    }

    @Nonnull
    public static ProcessorSupplier readFiles(@Nonnull String directory) {
        return Sources.readFiles(directory, StandardCharsets.UTF_8, "*");
    }

    @Nonnull
    public static ProcessorSupplier readFiles(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob) {
        return ReadFilesP.supplier(directory, charset.name(), glob);
    }

    public static ProcessorSupplier streamFiles(@Nonnull String watchedDirectory) {
        return Sources.streamFiles(watchedDirectory, StandardCharsets.UTF_8, "*");
    }

    public static ProcessorSupplier streamFiles(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob) {
        return StreamFilesP.supplier(watchedDirectory, charset.name(), glob);
    }
}

