/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.processor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.DistributedIntFunction;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteFileP;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public final class Sinks {
    private Sinks() {
    }

    @Nonnull
    public static ProcessorSupplier writeMap(@Nonnull String mapName) {
        return HazelcastWriters.writeMap(mapName);
    }

    @Nonnull
    public static ProcessorSupplier writeMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeMap(mapName, clientConfig);
    }

    @Nonnull
    public static ProcessorSupplier writeCache(@Nonnull String cacheName) {
        return HazelcastWriters.writeCache(cacheName);
    }

    @Nonnull
    public static ProcessorSupplier writeCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeCache(cacheName, clientConfig);
    }

    @Nonnull
    public static ProcessorSupplier writeList(@Nonnull String listName) {
        return HazelcastWriters.writeList(listName);
    }

    @Nonnull
    public static ProcessorSupplier writeList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return HazelcastWriters.writeList(listName, clientConfig);
    }

    @Nonnull
    public static <B, T> ProcessorSupplier writeBuffered(@Nonnull DistributedIntFunction<B> newBufferF, @Nonnull DistributedBiConsumer<B, T> addToBufferF, @Nonnull DistributedConsumer<B> flushBufferF) {
        return Sinks.writeBuffered(newBufferF, addToBufferF, flushBufferF, DistributedFunctions.noopConsumer());
    }

    @Nonnull
    public static <B, T> ProcessorSupplier writeBuffered(@Nonnull DistributedIntFunction<B> newBufferF, @Nonnull DistributedBiConsumer<B, T> addToBufferF, @Nonnull DistributedConsumer<B> flushBufferF, @Nonnull DistributedConsumer<B> disposeBufferF) {
        return WriteBufferedP.supplier(newBufferF, addToBufferF, flushBufferF, disposeBufferF);
    }

    public static ProcessorSupplier writeSocket(@Nonnull String host, int port) {
        return Sinks.writeSocket(host, port, Object::toString, StandardCharsets.UTF_8);
    }

    public static <T> ProcessorSupplier writeSocket(@Nonnull String host, int port, @Nonnull DistributedFunction<T, String> toStringF) {
        return Sinks.writeSocket(host, port, toStringF, StandardCharsets.UTF_8);
    }

    public static <T> ProcessorSupplier writeSocket(@Nonnull String host, int port, @Nonnull DistributedFunction<T, String> toStringF, @Nonnull Charset charset) {
        String charsetName = charset.name();
        return Sinks.writeBuffered(index -> Util.uncheckCall(() -> new BufferedWriter(new OutputStreamWriter(new Socket(host, port).getOutputStream(), charsetName))), (bufferedWriter, item) -> {
            try {
                bufferedWriter.write((String)toStringF.apply(item));
                bufferedWriter.write(10);
            }
            catch (IOException e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }, bufferedWriter -> Util.uncheckRun(bufferedWriter::flush), bufferedWriter -> Util.uncheckRun(bufferedWriter::close));
    }

    @Nonnull
    public static ProcessorSupplier writeFile(@Nonnull String directoryName) {
        return Sinks.writeFile(directoryName, Object::toString, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <T> ProcessorSupplier writeFile(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringF) {
        return Sinks.writeFile(directoryName, toStringF, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <T> ProcessorSupplier writeFile(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringF, @Nonnull Charset charset, boolean append) {
        return WriteFileP.supplier(directoryName, toStringF, charset.name(), append);
    }
}

