/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.util.Preconditions;
import java.util.Arrays;

public class TimestampHistory {
    private final long[] samples;
    private final long sampleInterval;
    private int tailIndex;
    private long advanceAt = Long.MIN_VALUE;

    public TimestampHistory(long maxDelay, int numStoredSamples) {
        Preconditions.checkPositive(numStoredSamples, "numStoredSamples must be at least one");
        this.samples = new long[numStoredSamples + 1];
        this.sampleInterval = maxDelay / (long)numStoredSamples;
        Preconditions.checkPositive(this.sampleInterval, "maxDelay must be at least as much as numStoredSamples");
        Arrays.fill(this.samples, Long.MIN_VALUE);
    }

    public long sample(long now, long value) {
        int i;
        for (i = 0; this.advanceAt <= now && i < this.samples.length; ++i) {
            int oldTailIdx = this.tailIndex;
            this.tailIndex = this.nextTailIndex();
            this.samples[this.tailIndex] = this.samples[oldTailIdx];
            this.advanceAt += this.sampleInterval;
        }
        if (i == this.samples.length) {
            this.advanceAt = now + this.sampleInterval;
        }
        this.samples[this.tailIndex] = value;
        return this.samples[this.nextTailIndex()];
    }

    private int nextTailIndex() {
        return this.tailIndex + 1 < this.samples.length ? this.tailIndex + 1 : 0;
    }
}

