/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.Outbox;
import com.hazelcast.jet.impl.util.ProgressTracker;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.annotation.Nonnull;

public final class ArrayDequeOutbox
implements Outbox {
    private final Queue<Object>[] buckets;
    private final int[] capacities;
    private final ProgressTracker progTracker;

    public ArrayDequeOutbox(int[] capacities, ProgressTracker progTracker) {
        this.capacities = (int[])capacities.clone();
        this.buckets = new Queue[capacities.length];
        this.progTracker = progTracker;
        Arrays.setAll(this.buckets, i -> new ArrayDeque());
    }

    @Override
    public int bucketCount() {
        return this.buckets.length;
    }

    @Override
    public boolean offer(int ordinal, @Nonnull Object item) {
        if (ordinal != -1) {
            if (this.isBucketFull(ordinal)) {
                return false;
            }
            this.buckets[ordinal].add(item);
            this.progTracker.madeProgress();
            return true;
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (!this.isBucketFull(i)) continue;
            return false;
        }
        for (Queue<Object> bucket : this.buckets) {
            bucket.add(item);
        }
        this.progTracker.madeProgress();
        return true;
    }

    @Override
    public boolean offer(int[] ordinals, @Nonnull Object item) {
        for (int ord : ordinals) {
            if (!this.isBucketFull(ord)) continue;
            return false;
        }
        for (int ord : ordinals) {
            this.buckets[ord].add(item);
        }
        this.progTracker.madeProgress();
        return true;
    }

    private boolean isBucketFull(int ordinal) {
        return this.buckets[ordinal].size() >= this.capacities[ordinal];
    }

    public String toString() {
        return Arrays.toString(this.buckets);
    }

    public Queue<Object> queueWithOrdinal(int ordinal) {
        return this.buckets[ordinal];
    }

    public void addIgnoringCapacity(Object item) {
        for (Queue<Object> bucket : this.buckets) {
            bucket.add(item);
        }
    }
}

