/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Outbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public final class PeekWrappedP
implements Processor {
    private final Processor wrappedProcessor;
    private final DistributedFunction<Object, String> toStringF;
    private final Predicate<Object> shouldLogF;
    private final boolean peekInput;
    private final boolean peekOutput;
    private final LoggingInbox loggingInbox;
    private ILogger logger;

    public PeekWrappedP(Processor wrappedProcessor, DistributedFunction<Object, String> toStringF, Predicate<Object> shouldLogF, boolean peekInput, boolean peekOutput) {
        if (!peekInput && !peekOutput) {
            throw new IllegalArgumentException("Peeking neither on input nor on output");
        }
        Preconditions.checkNotNull(wrappedProcessor, "wrappedProcessor");
        this.wrappedProcessor = wrappedProcessor;
        this.toStringF = toStringF;
        this.shouldLogF = shouldLogF;
        this.peekInput = peekInput;
        this.peekOutput = peekOutput;
        this.loggingInbox = peekInput ? new LoggingInbox() : null;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.logger = context.logger();
        if (this.peekOutput) {
            outbox = new LoggingOutbox(outbox);
        }
        this.wrappedProcessor.init(outbox, context);
    }

    @Override
    public boolean isCooperative() {
        return this.wrappedProcessor.isCooperative();
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.peekInput) {
            this.loggingInbox.wrappedInbox = inbox;
            this.wrappedProcessor.process(ordinal, this.loggingInbox);
        } else {
            this.wrappedProcessor.process(ordinal, inbox);
        }
    }

    @Override
    public boolean tryProcess() {
        return this.wrappedProcessor.tryProcess();
    }

    @Override
    public boolean complete() {
        return this.wrappedProcessor.complete();
    }

    private void log(Object object) {
        if (object != null && this.shouldLogF.test(object)) {
            this.logger.info(this.toStringF.apply(object));
        }
    }

    private final class LoggingOutbox
    implements Outbox {
        private final Outbox wrappedOutbox;

        private LoggingOutbox(Outbox wrappedOutbox) {
            this.wrappedOutbox = wrappedOutbox;
        }

        @Override
        public int bucketCount() {
            return this.wrappedOutbox.bucketCount();
        }

        @Override
        public boolean offer(int ordinal, @Nonnull Object item) {
            if (this.wrappedOutbox.offer(ordinal, item)) {
                PeekWrappedP.this.log(item);
                return true;
            }
            return false;
        }

        @Override
        public boolean offer(int[] ordinals, @Nonnull Object item) {
            if (this.wrappedOutbox.offer(ordinals, item)) {
                PeekWrappedP.this.log(item);
                return true;
            }
            return false;
        }
    }

    private class LoggingInbox
    implements Inbox {
        private Inbox wrappedInbox;
        private boolean wasLogged;

        private LoggingInbox() {
        }

        @Override
        public boolean isEmpty() {
            return this.wrappedInbox.isEmpty();
        }

        @Override
        public Object peek() {
            Object res = this.wrappedInbox.peek();
            if (!this.wasLogged && res != null) {
                PeekWrappedP.this.log(res);
                this.wasLogged = true;
            }
            return res;
        }

        @Override
        public Object poll() {
            Object res = this.wrappedInbox.poll();
            if (!this.wasLogged && res != null) {
                PeekWrappedP.this.log(res);
            }
            this.wasLogged = false;
            return res;
        }

        @Override
        public Object remove() {
            this.wasLogged = false;
            return this.wrappedInbox.remove();
        }
    }
}

