/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.ResettableSingletonTraverser;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Watermark;
import com.hazelcast.jet.WatermarkEmissionPolicy;
import com.hazelcast.jet.WatermarkPolicy;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;

public class InsertWatermarksP<T>
extends AbstractProcessor {
    private final ToLongFunction<T> getTimestampF;
    private final WatermarkPolicy wmPolicy;
    private final WatermarkEmissionPolicy wmEmitPolicy;
    private final ResettableSingletonTraverser<Object> singletonTraverser;
    private final AbstractProcessor.FlatMapper<Object, Object> flatMapper;
    private long currWm = Long.MIN_VALUE;
    private long lastEmittedWm = Long.MIN_VALUE;

    public InsertWatermarksP(@Nonnull ToLongFunction<T> getTimestampF, @Nonnull WatermarkPolicy wmPolicy, @Nonnull WatermarkEmissionPolicy wmEmitPolicy) {
        this.getTimestampF = getTimestampF;
        this.wmPolicy = wmPolicy;
        this.wmEmitPolicy = wmEmitPolicy;
        this.flatMapper = this.flatMapper(this::traverser);
        this.singletonTraverser = new ResettableSingletonTraverser();
    }

    @Override
    public boolean tryProcess() {
        this.currWm = this.wmPolicy.getCurrentWatermark();
        if (!this.wmEmitPolicy.shouldEmit(this.currWm, this.lastEmittedWm)) {
            return true;
        }
        boolean didEmit = this.tryEmit(new Watermark(this.currWm));
        if (didEmit) {
            this.lastEmittedWm = this.currWm;
        }
        return didEmit;
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        return this.flatMapper.tryProcess(item);
    }

    private Traverser<Object> traverser(Object item) {
        long timestamp = this.getTimestampF.applyAsLong(item);
        if (timestamp < this.currWm) {
            return Traversers.empty();
        }
        this.currWm = this.wmPolicy.reportEvent(timestamp);
        this.singletonTraverser.accept(item);
        if (this.wmEmitPolicy.shouldEmit(this.currWm, this.lastEmittedWm)) {
            this.lastEmittedWm = this.currWm;
            return this.singletonTraverser.prepend(new Watermark(this.currWm));
        }
        return this.singletonTraverser;
    }
}

