/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.AggregateOperation;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class GroupByKeyP<T, K, A, R>
extends AbstractProcessor {
    private final Function<? super T, ? extends K> getKeyF;
    private final AggregateOperation<? super T, A, R> aggrOp;
    private final Map<K, A> groups = new HashMap<K, A>();
    private final Traverser<Map.Entry<K, R>> resultTraverser;

    public GroupByKeyP(@Nonnull Function<? super T, ? extends K> getKeyF, @Nonnull AggregateOperation<? super T, A, R> aggregateOperation) {
        this.getKeyF = getKeyF;
        this.aggrOp = aggregateOperation;
        this.resultTraverser = Traversers.traverseStream(this.groups.entrySet().stream().map(e -> Util.entry(e.getKey(), this.aggrOp.finishAccumulationF().apply(e.getValue()))));
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Object acc = this.groups.computeIfAbsent(this.getKeyF.apply(item), k -> this.aggrOp.createAccumulatorF().get());
        this.aggrOp.accumulateItemF().accept(acc, item);
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.resultTraverser);
    }
}

