/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import java.util.concurrent.CompletionStage;

class ExecuteOperation
extends AsyncExecutionOperation {
    private volatile CompletionStage<Void> executionFuture;

    ExecuteOperation(long executionId) {
        super(executionId);
    }

    private ExecuteOperation() {
    }

    @Override
    public void cancel() {
        if (this.executionFuture != null) {
            this.executionFuture.toCompletableFuture().cancel(true);
        }
    }

    @Override
    protected void doRun() throws Exception {
        JetService service = (JetService)this.getService();
        this.getLogger().info("Start execution of plan for job " + this.executionId + " from caller " + this.getCallerAddress() + '.');
        this.executionFuture = service.getExecutionContext(this.executionId).execute(f -> f.handle((r, error) -> error != null ? error : null).thenAccept(value -> {
            this.getLogger().fine("Execution of plan for job " + this.executionId + " completed.");
            this.doSendResponse(value);
        }));
    }
}

