/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AsyncExecutionOperation
extends Operation {
    protected long executionId;

    protected AsyncExecutionOperation() {
    }

    protected AsyncExecutionOperation(long executionId) {
        this.executionId = executionId;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeRun() throws Exception {
        JetService service = (JetService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public final void run() throws Exception {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
        }
    }

    public abstract void cancel();

    protected abstract void doRun() throws Exception;

    public long getExecutionId() {
        return this.executionId;
    }

    protected final void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            JetService service = (JetService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

