/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.BlockingProcessorTasklet;
import com.hazelcast.jet.impl.execution.ConcurrentInboundEdgeStream;
import com.hazelcast.jet.impl.execution.ConveyorCollector;
import com.hazelcast.jet.impl.execution.ConveyorCollectorWithPartition;
import com.hazelcast.jet.impl.execution.CooperativeProcessorTasklet;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.execution.OutboundEdgeStream;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetImplDataSerializerHook;
import com.hazelcast.jet.impl.execution.init.PartitionArrangement;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.partition.IPartitionService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ExecutionPlan
implements IdentifiedDataSerializable {
    private final List<Tasklet> tasklets = new ArrayList<Tasklet>();
    private final Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = new HashMap<Integer, Map<Integer, Map<Address, ReceiverTasklet>>>();
    private final Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = new HashMap<Integer, Map<Integer, Map<Address, SenderTasklet>>>();
    private Address[] partitionOwners;
    private List<VertexDef> vertices = new ArrayList<VertexDef>();
    private final Map<String, ConcurrentConveyor<Object>[]> localConveyorMap = new HashMap<String, ConcurrentConveyor<Object>[]>();
    private final Map<String, Map<Address, ConcurrentConveyor<Object>>> edgeSenderConveyorMap = new HashMap<String, Map<Address, ConcurrentConveyor<Object>>>();
    private final List<Processor> processors = new ArrayList<Processor>();
    private PartitionArrangement ptionArrgmt;
    private NodeEngine nodeEngine;
    private long executionId;

    ExecutionPlan() {
    }

    ExecutionPlan(Address[] partitionOwners) {
        this.partitionOwners = partitionOwners;
    }

    public void initialize(NodeEngine nodeEngine, long executionId) {
        this.nodeEngine = nodeEngine;
        this.executionId = executionId;
        this.initProcSuppliers();
        this.initDag();
        this.ptionArrgmt = new PartitionArrangement(this.partitionOwners, nodeEngine.getThisAddress());
        JetInstance instance = Util.getJetInstance(nodeEngine);
        for (VertexDef srcVertex : this.vertices) {
            int processorIdx = 0;
            for (Processor processor : ExecutionPlan.createProcessors(srcVertex, srcVertex.parallelism())) {
                ILogger logger = nodeEngine.getLogger(processor.getClass().getName() + '.' + srcVertex.name() + '#' + processorIdx);
                Contexts.ProcCtx context = new Contexts.ProcCtx(instance, logger, srcVertex.name(), processorIdx + srcVertex.getProcIdxOffset());
                List<OutboundEdgeStream> outboundStreams = this.createOutboundEdgeStreams(srcVertex, processorIdx);
                List<InboundEdgeStream> inboundStreams = this.createInboundEdgeStreams(srcVertex, processorIdx);
                this.tasklets.add(processor.isCooperative() ? new CooperativeProcessorTasklet(context, processor, inboundStreams, outboundStreams) : new BlockingProcessorTasklet(context, processor, inboundStreams, outboundStreams));
                this.processors.add(processor);
                ++processorIdx;
            }
        }
        List allReceivers = this.receiverMap.values().stream().flatMap(o -> o.values().stream()).flatMap(a -> a.values().stream()).collect(Collectors.toList());
        this.tasklets.addAll(allReceivers);
    }

    public List<ProcessorSupplier> getProcessorSuppliers() {
        return this.vertices.stream().map(VertexDef::processorSupplier).collect(Collectors.toList());
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> getReceiverMap() {
        return this.receiverMap;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> getSenderMap() {
        return this.senderMap;
    }

    public List<Tasklet> getTasklets() {
        return this.tasklets;
    }

    void addVertex(VertexDef vertex) {
        this.vertices.add(vertex);
    }

    @Override
    public int getFactoryId() {
        return JetImplDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        Util.writeList(out, this.vertices);
        out.writeInt(this.partitionOwners.length);
        for (Address address : this.partitionOwners) {
            out.writeObject(address);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vertices = Util.readList(in);
        int len = in.readInt();
        this.partitionOwners = new Address[len];
        for (int i = 0; i < len; ++i) {
            this.partitionOwners[i] = (Address)in.readObject();
        }
    }

    private void initProcSuppliers() {
        JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
        this.vertices.forEach(v -> v.processorSupplier().init(new Contexts.ProcSupplierCtx(service.getJetInstance(), v.parallelism())));
    }

    private void initDag() {
        Map<Integer, VertexDef> vMap = this.vertices.stream().collect(Collectors.toMap(VertexDef::vertexId, v -> v));
        this.vertices.forEach(v -> {
            v.inboundEdges().forEach(e -> e.initTransientFields(vMap, (VertexDef)v, false));
            v.outboundEdges().forEach(e -> e.initTransientFields(vMap, (VertexDef)v, true));
        });
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        this.vertices.stream().map(VertexDef::outboundEdges).flatMap(Collection::stream).map(EdgeDef::partitioner).filter(Objects::nonNull).forEach(p -> p.init(partitionService::getPartitionId));
    }

    private static Collection<? extends Processor> createProcessors(VertexDef vertexDef, int parallelism) {
        Collection<? extends Processor> processors = vertexDef.processorSupplier().get(parallelism);
        if (processors.size() != parallelism) {
            throw new JetException("ProcessorSupplier failed to return the requested number of processors. Requested: " + parallelism + ", returned: " + processors.size());
        }
        return processors;
    }

    private List<OutboundEdgeStream> createOutboundEdgeStreams(VertexDef srcVertex, int processorIdx) {
        ArrayList<OutboundEdgeStream> outboundStreams = new ArrayList<OutboundEdgeStream>();
        for (EdgeDef edge : srcVertex.outboundEdges()) {
            Map<Address, ConcurrentConveyor<Object>> memberToSenderConveyorMap = edge.isDistributed() ? this.memberToSenderConveyorMap(this.edgeSenderConveyorMap, edge) : null;
            outboundStreams.add(this.createOutboundEdgeStream(edge, processorIdx, memberToSenderConveyorMap));
        }
        return outboundStreams;
    }

    private Map<Address, ConcurrentConveyor<Object>> memberToSenderConveyorMap(Map<String, Map<Address, ConcurrentConveyor<Object>>> edgeSenderConveyorMap, EdgeDef edge) {
        assert (edge.isDistributed()) : "Edge is not distributed";
        return edgeSenderConveyorMap.computeIfAbsent(edge.edgeId(), x -> {
            HashMap<Address, ConcurrentConveyor<Object>> addrToConveyor = new HashMap<Address, ConcurrentConveyor<Object>>();
            for (Address destAddr : Util.getRemoteMembers(this.nodeEngine)) {
                ConcurrentConveyor<Object> conveyor = ExecutionPlan.createConveyorArray(1, edge.sourceVertex().parallelism(), edge.getConfig().getQueueSize())[0];
                ConcurrentInboundEdgeStream inboundEdgeStream = new ConcurrentInboundEdgeStream(conveyor, edge.destOrdinal(), edge.priority());
                int destVertexId = edge.destVertex().vertexId();
                SenderTasklet t = new SenderTasklet(inboundEdgeStream, this.nodeEngine, destAddr, this.executionId, destVertexId, edge.getConfig().getPacketSizeLimit());
                this.senderMap.computeIfAbsent(destVertexId, xx -> new HashMap()).computeIfAbsent(edge.destOrdinal(), xx -> new HashMap()).put(destAddr, t);
                this.tasklets.add(t);
                addrToConveyor.put(destAddr, conveyor);
            }
            return addrToConveyor;
        });
    }

    private static ConcurrentConveyor<Object>[] createConveyorArray(int count, int queueCount, int queueSize) {
        ConcurrentConveyor[] concurrentConveyors = new ConcurrentConveyor[count];
        Arrays.setAll(concurrentConveyors, i -> {
            QueuedPipe[] queues = new QueuedPipe[queueCount];
            Arrays.setAll(queues, j -> new OneToOneConcurrentArrayQueue(queueSize));
            return ConcurrentConveyor.concurrentConveyor(null, queues);
        });
        return concurrentConveyors;
    }

    private OutboundEdgeStream createOutboundEdgeStream(EdgeDef edge, int processorIndex, Map<Address, ConcurrentConveyor<Object>> senderConveyorMap) {
        int totalPtionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        OutboundCollector[] outboundCollectors = this.createOutboundCollectors(edge, processorIndex, senderConveyorMap);
        int outboxLimit = edge.isBuffered() ? Integer.MAX_VALUE : edge.getConfig().getOutboxCapacity();
        OutboundCollector compositeCollector = OutboundCollector.compositeCollector(outboundCollectors, edge, totalPtionCount);
        return new OutboundEdgeStream(edge.sourceOrdinal(), outboxLimit, compositeCollector);
    }

    private OutboundCollector[] createOutboundCollectors(EdgeDef edge, int processorIndex, Map<Address, ConcurrentConveyor<Object>> senderConveyorMap) {
        int upstreamParallelism = edge.sourceVertex().parallelism();
        int downstreamParallelism = edge.destVertex().parallelism();
        int numRemoteMembers = this.ptionArrgmt.remotePartitionAssignment.get().size();
        int queueSize = edge.getConfig().getQueueSize();
        int[][] ptionsPerProcessor = this.ptionArrgmt.assignPartitionsToProcessors(downstreamParallelism, edge.isDistributed());
        if (edge.routingPolicy() == Edge.RoutingPolicy.ISOLATED) {
            if (downstreamParallelism < upstreamParallelism) {
                throw new IllegalArgumentException(String.format("The edge %s specifies the %s routing policy, but the downstream vertex parallelism (%d) is less than the upstream vertex parallelism (%d)", edge, Edge.RoutingPolicy.ISOLATED.name(), downstreamParallelism, upstreamParallelism));
            }
            if (edge.isDistributed()) {
                throw new IllegalArgumentException("One to many edges must be local: " + edge);
            }
            ConcurrentConveyor[] localConveyors = this.localConveyorMap.computeIfAbsent(edge.edgeId(), e -> ExecutionPlan.createConveyorArray(downstreamParallelism, 1, queueSize));
            return (OutboundCollector[])IntStream.range(0, downstreamParallelism).filter(i -> i % upstreamParallelism == processorIndex).mapToObj(i -> new ConveyorCollector(localConveyors[i], 0, ptionsPerProcessor[i])).toArray(OutboundCollector[]::new);
        }
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.computeIfAbsent(edge.edgeId(), e -> {
            int queueCount = upstreamParallelism + (edge.isDistributed() ? numRemoteMembers : 0);
            return ExecutionPlan.createConveyorArray(downstreamParallelism, queueCount, queueSize);
        });
        OutboundCollector[] localCollectors = new OutboundCollector[downstreamParallelism];
        Arrays.setAll(localCollectors, n -> new ConveyorCollector(localConveyors[n], processorIndex, ptionsPerProcessor[n]));
        if (!edge.isDistributed()) {
            return localCollectors;
        }
        int totalPtionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        this.createIfAbsentReceiverTasklet(edge, ptionsPerProcessor, totalPtionCount);
        Map<Address, int[]> memberToPartitions = this.ptionArrgmt.remotePartitionAssignment.get();
        OutboundCollector[] allCollectors = new OutboundCollector[memberToPartitions.size() + 1];
        allCollectors[0] = OutboundCollector.compositeCollector(localCollectors, edge, totalPtionCount);
        int index = 1;
        for (Map.Entry<Address, int[]> entry : memberToPartitions.entrySet()) {
            allCollectors[index++] = new ConveyorCollectorWithPartition(senderConveyorMap.get(entry.getKey()), processorIndex, entry.getValue());
        }
        return allCollectors;
    }

    private void createIfAbsentReceiverTasklet(EdgeDef edge, int[][] ptionsPerProcessor, int totalPtionCount) {
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.get(edge.edgeId());
        this.receiverMap.computeIfAbsent(edge.destVertex().vertexId(), x -> new HashMap()).computeIfAbsent(edge.destOrdinal(), x -> {
            HashMap<Address, ReceiverTasklet> addrToTasklet = new HashMap<Address, ReceiverTasklet>();
            int offset = 0;
            for (Address addr : this.ptionArrgmt.remotePartitionAssignment.get().keySet()) {
                OutboundCollector[] collectors = new OutboundCollector[ptionsPerProcessor.length];
                int queueOffset = --offset;
                Arrays.setAll(collectors, n -> new ConveyorCollector(localConveyors[n], localConveyors[n].queueCount() + queueOffset, ptionsPerProcessor[n]));
                OutboundCollector collector = OutboundCollector.compositeCollector(collectors, edge, totalPtionCount);
                ReceiverTasklet receiverTasklet = new ReceiverTasklet(collector, edge.getConfig().getReceiveWindowMultiplier(), this.getConfig().getInstanceConfig().getFlowControlPeriodMs());
                addrToTasklet.put(addr, receiverTasklet);
            }
            return addrToTasklet;
        });
    }

    private JetConfig getConfig() {
        JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
        return service.getJetInstance().getConfig();
    }

    private List<InboundEdgeStream> createInboundEdgeStreams(VertexDef srcVertex, int processorIdx) {
        ArrayList<InboundEdgeStream> inboundStreams = new ArrayList<InboundEdgeStream>();
        for (EdgeDef inEdge : srcVertex.inboundEdges()) {
            ConcurrentConveyor<Object> conveyor = this.localConveyorMap.get(inEdge.edgeId())[processorIdx];
            inboundStreams.add(new ConcurrentInboundEdgeStream(conveyor, inEdge.destOrdinal(), inEdge.priority()));
        }
        return inboundStreams;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }
}

