/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class Contexts {
    private Contexts() {
    }

    static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final JetInstance jetInstance;
        private final int totalParallelism;
        private final int localParallelism;

        MetaSupplierCtx(JetInstance jetInstance, int totalParallelism, int localParallelism) {
            this.jetInstance = jetInstance;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.jetInstance;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }
    }

    static class ProcSupplierCtx
    implements ProcessorSupplier.Context {
        private final JetInstance instance;
        private final int perNodeParallelism;

        ProcSupplierCtx(JetInstance instance, int perNodeParallelism) {
            this.instance = instance;
            this.perNodeParallelism = perNodeParallelism;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.instance;
        }

        @Override
        public int localParallelism() {
            return this.perNodeParallelism;
        }
    }

    public static class ProcCtx
    implements Processor.Context {
        private final JetInstance instance;
        private final ILogger logger;
        private final String vertexName;
        private final int index;
        private CompletableFuture<Void> jobFuture;

        public ProcCtx(JetInstance instance, ILogger logger, String vertexName, int index) {
            this.instance = instance;
            this.logger = logger;
            this.vertexName = vertexName;
            this.index = index;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.instance;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }

        @Override
        public int globalProcessorIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        @Nonnull
        public CompletableFuture<Void> jobFuture() {
            return this.jobFuture;
        }

        public void initJobFuture(CompletableFuture<Void> jobFuture) {
            assert (this.jobFuture == null) : "jobFuture already initialized";
            this.jobFuture = jobFuture;
        }
    }
}

