/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ExecutionService;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class ExecutionContext {
    private Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = Collections.emptyMap();
    private Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = Collections.emptyMap();
    private List<ProcessorSupplier> procSuppliers = Collections.emptyList();
    private List<Processor> processors = Collections.emptyList();
    private Set<Address> participatingMembers = Collections.emptySet();
    private List<Tasklet> tasklets;
    private CompletionStage<Void> jobFuture;
    private final long executionId;
    private final NodeEngine nodeEngine;
    private final ExecutionService execService;

    public ExecutionContext(long executionId, NodeEngine nodeEngine, ExecutionService execService) {
        this.executionId = executionId;
        this.execService = execService;
        this.nodeEngine = nodeEngine;
    }

    public ExecutionContext initialize(ExecutionPlan plan) {
        this.participatingMembers = Collections.unmodifiableSet(new HashSet<Address>(Util.getRemoteMembers(this.nodeEngine)));
        this.procSuppliers = Collections.unmodifiableList(plan.getProcessorSuppliers());
        this.processors = plan.getProcessors();
        plan.initialize(this.nodeEngine, this.executionId);
        this.receiverMap = Collections.unmodifiableMap(plan.getReceiverMap());
        this.senderMap = Collections.unmodifiableMap(plan.getSenderMap());
        this.tasklets = plan.getTasklets();
        return this;
    }

    public CompletionStage<Void> execute(Consumer<CompletionStage<Void>> doneCallback) {
        JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
        ClassLoader cl = service.getClassLoader(this.executionId);
        this.jobFuture = this.execService.execute(this.tasklets, doneCallback, cl);
        this.jobFuture.whenComplete((r, e) -> this.tasklets.clear());
        return this.jobFuture;
    }

    public CompletionStage<Void> getJobFuture() {
        return this.jobFuture;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap() {
        return this.senderMap;
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap() {
        return this.receiverMap;
    }

    public void complete(Throwable error) {
        this.procSuppliers.forEach(s -> s.complete(error));
        MetricsRegistry metricsRegistry = ((NodeEngineImpl)this.nodeEngine).getMetricsRegistry();
        this.processors.forEach(metricsRegistry::deregister);
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, BufferObjectDataInput in) {
        this.receiverMap.get(vertexId).get(ordinal).get(sender).receiveStreamPacket(in);
    }

    public boolean isParticipating(Address member) {
        return this.participatingMembers != null && this.participatingMembers.contains(member);
    }
}

