/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ResourceUpdateOperation
extends Operation {
    private long executionId;
    private ResourcePart part;

    private ResourceUpdateOperation() {
    }

    public ResourceUpdateOperation(long executionId, ResourcePart part) {
        this.executionId = executionId;
        this.part = part;
    }

    @Override
    public void run() throws Exception {
        JetService service = (JetService)this.getService();
        service.getResourceStore(this.executionId).updateResource(this.part);
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeObject(this.part);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.part = (ResourcePart)in.readObject();
    }
}

