/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.impl.deployment.ClassLoaderEntry;
import com.hazelcast.jet.impl.deployment.ResourceDescriptor;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.UuidUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ResourceStore {
    private static final int BUFFER_SIZE = 1024;
    private final ILogger log;
    private Path storageDirectory;
    private final Map<ResourceDescriptor, File> resources = new ConcurrentHashMap<ResourceDescriptor, File>();
    private final Map<String, ClassLoaderEntry> jarEntries = new ConcurrentHashMap<String, ClassLoaderEntry>();
    private final Map<String, ClassLoaderEntry> dataEntries = new ConcurrentHashMap<String, ClassLoaderEntry>();
    private final Map<String, ClassLoaderEntry> classEntries = new ConcurrentHashMap<String, ClassLoaderEntry>();

    public ResourceStore(Path rootDir, NodeEngine nodeEngine) {
        this.log = nodeEngine.getLogger(this.getClass());
        this.storageDirectory = Util.uncheckCall(() -> Files.createTempDirectory(rootDir, "hazelcast-jet-resources", new FileAttribute[0]));
    }

    public void destroy() {
        try {
            IOUtil.delete(this.storageDirectory.toFile());
        }
        catch (Exception e) {
            this.log.warning(e);
        }
        this.storageDirectory = null;
        this.resources.clear();
        this.jarEntries.clear();
        this.dataEntries.clear();
        this.classEntries.clear();
    }

    Map<String, ClassLoaderEntry> getJarEntries() {
        return this.jarEntries;
    }

    Map<String, ClassLoaderEntry> getDataEntries() {
        return this.dataEntries;
    }

    Map<String, ClassLoaderEntry> getClassEntries() {
        return this.classEntries;
    }

    synchronized void updateResource(ResourcePart part) throws IOException {
        File file = this.resources.computeIfAbsent(part.getDescriptor(), this::createResource);
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.seek(part.getOffset());
            raf.write(part.getBytes());
        }
    }

    void completeResource(ResourceDescriptor descriptor) throws IOException {
        File resource = this.resources.get(descriptor);
        Throwable throwable = null;
        try (FileInputStream stream = new FileInputStream(resource);){
            String resourceUri = resource.toURI().toString();
            switch (descriptor.getResourceKind()) {
                case JAR: {
                    this.loadJarStream(stream, resourceUri);
                    return;
                }
                case CLASS: {
                    this.classEntries.put(descriptor.getId(), new ClassLoaderEntry(Util.readFully(stream), resourceUri));
                    return;
                }
                case DATA: {
                    this.dataEntries.put(descriptor.getId(), new ClassLoaderEntry(Util.readFully(stream), resourceUri));
                    return;
                }
            }
            try {
                throw new AssertionError((Object)("Unhandled resource type " + descriptor.getResourceKind()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private File createResource(ResourceDescriptor descriptor) {
        String fileName = descriptor.getId() + '-' + UuidUtil.newUnsecureUuidString();
        File file = Paths.get(this.storageDirectory.toString(), fileName).toFile();
        try {
            if (!file.createNewFile()) {
                throw new IOException("File " + file + " already exists.");
            }
            return file;
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void loadJarStream(FileInputStream stream, String uri) throws IOException {
        try (JarInputStream jis = new JarInputStream(new BufferedInputStream(stream));){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                int len;
                if (jarEntry.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                String name = jarEntry.getName();
                String clazzSuffix = ".class";
                if (jarEntry.getName().endsWith(clazzSuffix)) {
                    name = name.substring(0, name.length() - clazzSuffix.length()).replace("/", ".");
                }
                ClassLoaderEntry entry = new ClassLoaderEntry(out.toByteArray(), String.format("jar:%s!/%s", uri, name));
                this.jarEntries.put(name, entry);
            }
        }
    }
}

