/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ResourceIterator
implements Iterator<ResourcePart>,
AutoCloseable {
    static final int RESOURCE_PART_SIZE = 16384;
    private final Iterator<ResourceConfig> configIterator;
    private InputStream inputStream;
    private ResourceConfig resourceConfig;
    private int offset;
    private byte[] buffer;
    private ResourcePart nextPart;

    public ResourceIterator(Set<ResourceConfig> resourceConfigs) {
        this.configIterator = resourceConfigs.iterator();
        this.buffer = new byte[16384];
        this.readNext();
    }

    private void switchFile() throws IOException {
        this.resourceConfig = this.configIterator.next();
        this.inputStream = this.resourceConfig.getUrl().openStream();
        this.offset = 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextPart != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourcePart next() {
        if (this.nextPart == null) {
            throw new NoSuchElementException();
        }
        try {
            ResourcePart resourcePart = this.nextPart;
            return resourcePart;
        }
        finally {
            this.readNext();
        }
    }

    private void readNext() {
        try {
            this.nextPart = null;
            while (this.nextPart == null && (this.configIterator.hasNext() || this.inputStream != null)) {
                int bytesRead;
                if (this.inputStream == null) {
                    this.switchFile();
                }
                if ((bytesRead = this.inputStream.read(this.buffer)) < 0) {
                    bytesRead = 0;
                    this.inputStream.close();
                    this.inputStream = null;
                    if (this.offset > 0) continue;
                }
                this.nextPart = new ResourcePart(this.resourceConfig.getDescriptor(), Arrays.copyOf(this.buffer, bytesRead), this.offset);
                this.offset += bytesRead;
            }
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            Util.uncheckRun(() -> this.inputStream.close());
        }
    }
}

