/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.deployment.ResourceDescriptor;
import com.hazelcast.jet.impl.deployment.ResourceStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ResourceCompleteOperation
extends Operation {
    private long executionId;
    private ResourceDescriptor descriptor;

    private ResourceCompleteOperation() {
    }

    public ResourceCompleteOperation(long executionId, ResourceDescriptor descriptor) {
        this.executionId = executionId;
        this.descriptor = descriptor;
    }

    @Override
    public void run() throws Exception {
        JetService service = (JetService)this.getService();
        ResourceStore store = service.getResourceStore(this.executionId);
        store.completeResource(this.descriptor);
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeObject(this.descriptor);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.descriptor = (ResourceDescriptor)in.readObject();
    }
}

