/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Outbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Watermark;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedIntFunction;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class WriteBufferedP<B, T>
implements Processor {
    private final DistributedConsumer<B> flushBuffer;
    private final DistributedIntFunction<B> newBuffer;
    private final DistributedBiConsumer<B, T> addToBuffer;
    private final DistributedConsumer<B> disposeBuffer;
    private B buffer;

    WriteBufferedP(DistributedIntFunction<B> newBuffer, DistributedBiConsumer<B, T> addToBuffer, DistributedConsumer<B> flushBuffer, DistributedConsumer<B> disposeBuffer) {
        this.newBuffer = newBuffer;
        this.addToBuffer = addToBuffer;
        this.flushBuffer = flushBuffer;
        this.disposeBuffer = disposeBuffer;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.buffer = this.newBuffer.apply(context.globalProcessorIndex());
    }

    @Nonnull
    public static <B, T> ProcessorSupplier supplier(final DistributedIntFunction<B> newBufferF, final DistributedBiConsumer<B, T> addToBufferF, final DistributedConsumer<B> flushBufferF, final DistributedConsumer<B> disposeBufferF) {
        return new ProcessorSupplier(){
            private transient List<WriteBufferedP<B, T>> processors;

            @Override
            @Nonnull
            public Collection<? extends Processor> get(int count) {
                this.processors = IntStream.range(0, count).mapToObj(i -> new WriteBufferedP(newBufferF, addToBufferF, flushBufferF, disposeBufferF)).collect(Collectors.toList());
                return this.processors;
            }

            @Override
            public void complete(Throwable error) {
                if (this.processors == null) {
                    return;
                }
                for (WriteBufferedP p : this.processors) {
                    p.close();
                }
            }
        };
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drain(item -> {
            if (!(item instanceof Watermark)) {
                this.addToBuffer.accept(this.buffer, item);
            }
        });
        this.flushBuffer.accept(this.buffer);
    }

    @Override
    public boolean complete() {
        this.close();
        return true;
    }

    public void close() {
        this.disposeBuffer.accept(this.buffer);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }
}

