/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Partition;
import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import com.hazelcast.jet.impl.util.CircularListCursor;
import com.hazelcast.jet.processor.Processors;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.Address;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ReadWithPartitionIteratorP<T>
extends AbstractProcessor {
    private static final boolean PREFETCH_VALUES = true;
    private static final int DEFAULT_FETCH_SIZE = 16384;
    private final Traverser<T> outputTraverser;

    ReadWithPartitionIteratorP(Function<Integer, Iterator<T>> partitionToIterator, List<Integer> partitions) {
        CircularListCursor iteratorCursor = new CircularListCursor(partitions.stream().map(partitionToIterator).collect(Collectors.toList()));
        this.outputTraverser = () -> {
            do {
                Iterator currIterator;
                if ((currIterator = (Iterator)iteratorCursor.value()).hasNext()) {
                    iteratorCursor.advance();
                    return currIterator.next();
                }
                iteratorCursor.remove();
            } while (iteratorCursor.advance());
            return null;
        };
    }

    public static ProcessorMetaSupplier readMap(String mapName) {
        return ReadWithPartitionIteratorP.readMap(mapName, 16384);
    }

    public static <T> ProcessorMetaSupplier readMap(String mapName, int fetchSize) {
        return new LocalClusterMetaSupplier(instance -> partition -> ((MapProxyImpl)instance.getMap(mapName)).iterator(fetchSize, (int)partition, true));
    }

    public static ProcessorMetaSupplier readMap(String mapName, ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readMap(mapName, 16384, clientConfig);
    }

    public static <T> ProcessorMetaSupplier readMap(String mapName, int fetchSize, ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(clientConfig, instance -> partition -> ((ClientMapProxy)instance.getMap(mapName)).iterator(fetchSize, (int)partition, true));
    }

    public static ProcessorMetaSupplier readCache(String cacheName) {
        return ReadWithPartitionIteratorP.readCache(cacheName, 16384);
    }

    public static <T> ProcessorMetaSupplier readCache(String cacheName, int fetchSize) {
        return new LocalClusterMetaSupplier(instance -> partition -> ((CacheProxy)instance.getCacheManager().getCache(cacheName)).iterator(fetchSize, (int)partition, true));
    }

    public static ProcessorMetaSupplier readCache(String cacheName, ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readCache(cacheName, 16384, clientConfig);
    }

    public static <T> ProcessorMetaSupplier readCache(String cacheName, int fetchSize, ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(clientConfig, instance -> partition -> ((ClientCacheProxy)instance.getCacheManager().getCache(cacheName)).iterator(fetchSize, (int)partition, true));
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.outputTraverser);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    private static <T> List<Processor> getProcessors(int count, List<Integer> ownedPartitions, Function<Integer, Iterator<T>> partitionToIterator) {
        Map processorToPartitions = IntStream.range(0, ownedPartitions.size()).mapToObj(i -> Util.entry(i, ownedPartitions.get(i))).collect(Collectors.groupingBy(e -> (Integer)e.getKey() % count, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        IntStream.range(0, count).forEach(processor -> processorToPartitions.computeIfAbsent(processor, x -> Collections.emptyList()));
        return processorToPartitions.values().stream().map(partitions -> !partitions.isEmpty() ? new ReadWithPartitionIteratorP(partitionToIterator, (List<Integer>)partitions) : Processors.noop().get()).collect(Collectors.toList());
    }

    private static class LocalClusterProcessorSupplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final List<Integer> ownedPartitions;
        private final DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient Function<Integer, Iterator<T>> partitionToIterator;

        LocalClusterProcessorSupplier(List<Integer> ownedPartitions, DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.ownedPartitions = ownedPartitions != null ? ownedPartitions : Collections.emptyList();
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.partitionToIterator = this.iteratorSupplier.apply(context.jetInstance().getHazelcastInstance());
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadWithPartitionIteratorP.getProcessors(count, this.ownedPartitions, this.partitionToIterator);
        }
    }

    private static class LocalClusterMetaSupplier<T>
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient Map<Address, List<Integer>> addrToPartitions;

        LocalClusterMetaSupplier(DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            this.addrToPartitions = context.jetInstance().getHazelcastInstance().getPartitionService().getPartitions().stream().collect(Collectors.groupingBy(p -> p.getOwner().getAddress(), Collectors.mapping(Partition::getPartitionId, Collectors.toList())));
        }

        @Override
        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresseses) {
            return address -> new LocalClusterProcessorSupplier<T>(this.addrToPartitions.get(address), this.iteratorSupplier);
        }
    }

    private static class RemoteClusterProcessorSupplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final List<Integer> ownedPartitions;
        private final SerializableClientConfig serializableClientConfig;
        private final DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient HazelcastInstance client;
        private transient Function<Integer, Iterator<T>> partitionToIterator;

        RemoteClusterProcessorSupplier(List<Integer> ownedPartitions, SerializableClientConfig serializableClientConfig, DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.ownedPartitions = ownedPartitions;
            this.serializableClientConfig = serializableClientConfig;
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = HazelcastClient.newHazelcastClient(this.serializableClientConfig.asClientConfig());
            this.partitionToIterator = this.iteratorSupplier.apply(this.client);
        }

        @Override
        public void complete(Throwable error) {
            this.client.shutdown();
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadWithPartitionIteratorP.getProcessors(count, this.ownedPartitions, this.partitionToIterator);
        }
    }

    private static class RemoteClusterMetaSupplier<T>
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final SerializableClientConfig serializableConfig;
        private final DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient int remotePartitionCount;

        RemoteClusterMetaSupplier(ClientConfig clientConfig, DistributedFunction<HazelcastInstance, Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.serializableConfig = new SerializableClientConfig(clientConfig);
            this.iteratorSupplier = iteratorSupplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            HazelcastInstance client = HazelcastClient.newHazelcastClient(this.serializableConfig.asClientConfig());
            try {
                HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
                this.remotePartitionCount = clientProxy.client.getClientPartitionService().getPartitionCount();
            }
            finally {
                client.shutdown();
            }
        }

        @Override
        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            Map<Address, List<Integer>> membersToPartitions = IntStream.range(0, this.remotePartitionCount).boxed().collect(Collectors.groupingBy(partition -> (Address)addresses.get(partition % addresses.size())));
            return address -> new RemoteClusterProcessorSupplier<T>((List)membersToPartitions.get(address), this.serializableConfig, this.iteratorSupplier);
        }
    }
}

