/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.DistributedIntFunction;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static ProcessorSupplier writeMap(String name) {
        return HazelcastWriters.writeMap(name, null);
    }

    @Nonnull
    public static ProcessorSupplier writeMap(String name, ClientConfig clientConfig) {
        return new HazelcastWriterSupplier<ArrayMap, Map.Entry>(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayMap(), ArrayMap::add, instance -> {
            IMap map = instance.getMap(name);
            return buffer -> {
                map.putAll(buffer);
                buffer.clear();
            };
        }, DistributedFunctions.noopConsumer());
    }

    @Nonnull
    public static ProcessorSupplier writeCache(String name) {
        return HazelcastWriters.writeCache(name, null);
    }

    @Nonnull
    public static ProcessorSupplier writeCache(String name, ClientConfig clientConfig) {
        return new HazelcastWriterSupplier<ArrayMap, Map.Entry>(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayMap(), ArrayMap::add, CacheFlush.flushToCache(name), DistributedFunctions.noopConsumer());
    }

    @Nonnull
    public static ProcessorSupplier writeList(String name) {
        return HazelcastWriters.writeList(name, null);
    }

    @Nonnull
    public static ProcessorSupplier writeList(String name, ClientConfig clientConfig) {
        return new HazelcastWriterSupplier<ArrayList, Object>(HazelcastWriters.serializableConfig(clientConfig), index -> new ArrayList(), ArrayList::add, instance -> {
            IList list = instance.getList(name);
            return buffer -> {
                list.addAll(buffer);
                buffer.clear();
            };
        }, DistributedFunctions.noopConsumer());
    }

    private static SerializableClientConfig serializableConfig(ClientConfig clientConfig) {
        return clientConfig != null ? new SerializableClientConfig(clientConfig) : null;
    }

    private static class HazelcastWriterSupplier<B, T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final SerializableClientConfig clientConfig;
        private final DistributedFunction<HazelcastInstance, DistributedConsumer<B>> instanceToFlushBuffer;
        private final DistributedIntFunction<B> bufferSupplier;
        private final DistributedBiConsumer<B, T> addToBuffer;
        private final DistributedConsumer<B> disposeBuffer;
        private transient DistributedConsumer<B> flushBuffer;
        private transient HazelcastInstance client;

        HazelcastWriterSupplier(SerializableClientConfig clientConfig, DistributedIntFunction<B> newBuffer, DistributedBiConsumer<B, T> addToBuffer, DistributedFunction<HazelcastInstance, DistributedConsumer<B>> instanceToFlushBuffer, DistributedConsumer<B> disposeBuffer) {
            this.clientConfig = clientConfig;
            this.instanceToFlushBuffer = instanceToFlushBuffer;
            this.bufferSupplier = newBuffer;
            this.addToBuffer = addToBuffer;
            this.disposeBuffer = disposeBuffer;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient(this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
            this.flushBuffer = this.instanceToFlushBuffer.apply(instance);
        }

        @Override
        public void complete(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        private boolean isRemote() {
            return this.clientConfig != null;
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Stream.generate(() -> new WriteBufferedP<B, T>(this.bufferSupplier, this.addToBuffer, this.flushBuffer, this.disposeBuffer)).limit(count).collect(Collectors.toList());
        }
    }

    private static final class ArrayMap
    extends AbstractMap {
        private final List<Map.Entry> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry>();
        }

        @Override
        @Nonnull
        public Set<Map.Entry> entrySet() {
            return this.set;
        }

        public void add(Map.Entry entry) {
            this.entries.add(entry);
        }

        private class ArraySet
        extends AbstractSet<Map.Entry> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }
        }
    }

    private static class CacheFlush {
        private CacheFlush() {
        }

        static DistributedFunction<HazelcastInstance, DistributedConsumer<ArrayMap>> flushToCache(String name) {
            return instance -> {
                ICache cache = instance.getCacheManager().getCache(name);
                return buffer -> {
                    cache.putAll((Map)buffer);
                    buffer.clear();
                };
            };
        }
    }
}

