/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.LiveOperations;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class LiveOperationRegistry {
    final ConcurrentHashMap<Address, Map<Long, AsyncExecutionOperation>> liveOperations = new ConcurrentHashMap();

    public void register(AsyncExecutionOperation operation) {
        Map callIds = this.liveOperations.computeIfAbsent(operation.getCallerAddress(), key -> new ConcurrentHashMap());
        if (callIds.putIfAbsent(operation.getCallId(), operation) != null) {
            throw new IllegalStateException("Duplicate operation during registration of operation=" + operation);
        }
    }

    public void deregister(AsyncExecutionOperation operation) {
        Map<Long, AsyncExecutionOperation> operations = this.liveOperations.get(operation.getCallerAddress());
        if (operations == null) {
            throw new IllegalStateException("Missing address during de-registration of operation=" + operation);
        }
        if (operations.remove(operation.getCallId()) == null) {
            throw new IllegalStateException("Missing operation during de-registration of operation=" + operation);
        }
    }

    void populate(LiveOperations liveOperations) {
        this.liveOperations.entrySet().forEach(entry -> ((Map)entry.getValue()).keySet().forEach(callId -> liveOperations.add((Address)entry.getKey(), (long)callId)));
    }

    boolean cancel(Address caller, long callId) {
        Optional<AsyncExecutionOperation> operation = Optional.ofNullable(this.liveOperations.get(caller)).map(m -> (AsyncExecutionOperation)m.get(callId));
        operation.ifPresent(AsyncExecutionOperation::cancel);
        return operation.isPresent();
    }
}

