/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Member;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.deployment.ResourceCompleteOperation;
import com.hazelcast.jet.impl.deployment.ResourceIterator;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.jet.impl.deployment.ResourceUpdateOperation;
import com.hazelcast.jet.impl.operation.ExecuteJobOperation;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.function.Supplier;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class JetInstanceImpl
extends AbstractJetInstance {
    private final NodeEngine nodeEngine;
    private final JetConfig config;
    private final ILogger logger;

    public JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.logger = this.nodeEngine.getLogger(JetInstance.class);
        this.config = config;
    }

    @Override
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    public Job newJob(DAG dag) {
        return new JobImpl(dag);
    }

    @Override
    public Job newJob(DAG dag, JobConfig config) {
        return new JobImpl(dag, config);
    }

    private class JobImpl
    implements Job {
        private final DAG dag;
        private final JobConfig config;

        JobImpl(DAG dag) {
            this(dag, new JobConfig());
        }

        JobImpl(DAG dag, JobConfig config) {
            this.dag = dag;
            this.config = config;
        }

        @Override
        public Future<Void> execute() {
            long executionId = JetInstanceImpl.this.getIdGenerator().newId();
            this.deployResources(executionId);
            ExecuteJobOperation op = new ExecuteJobOperation(executionId, this.dag);
            return JetInstanceImpl.this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, JetInstanceImpl.this.nodeEngine.getThisAddress()).invoke();
        }

        private void deployResources(long executionId) {
            Set<ResourceConfig> resources = this.config.getResourceConfigs();
            if (JetInstanceImpl.this.logger.isFineEnabled() && resources.size() > 0) {
                JetInstanceImpl.this.logger.fine("Deploying the following resources for " + executionId + ':' + resources);
            }
            try (ResourceIterator it = new ResourceIterator(resources);){
                it.forEachRemaining(part -> this.invokeOnCluster(() -> new ResourceUpdateOperation(executionId, (ResourcePart)part)));
            }
            resources.forEach(r -> this.invokeOnCluster(() -> new ResourceCompleteOperation(executionId, r.getDescriptor())));
            JetInstanceImpl.this.logger.fine("Resource deployment for job " + executionId + " completed.");
        }

        private <T> List<T> invokeOnCluster(Supplier<Operation> supplier) {
            OperationService operationService = JetInstanceImpl.this.nodeEngine.getOperationService();
            Set<Member> members = JetInstanceImpl.this.nodeEngine.getClusterService().getMembers();
            return members.stream().map(member -> operationService.createInvocationBuilder("hz:impl:jetService", (Operation)supplier.get(), member.getAddress()).invoke()).collect(Collectors.toList()).stream().map(f -> Util.uncheckCall(f::get)).collect(Collectors.toList());
        }
    }
}

