/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DagValidator {
    private final Deque<Vertex> topologicalVertexStack = new ArrayDeque<Vertex>();

    public Collection<Vertex> validate(Map<String, Vertex> verticesByName, Set<Edge> edges) {
        this.topologicalVertexStack.clear();
        Preconditions.checkTrue(!verticesByName.isEmpty(), "DAG must contain at least one vertex");
        Map<String, List<Edge>> outgoingEdgeMap = edges.stream().collect(Collectors.groupingBy(Edge::getSourceName));
        DagValidator.validateOutboundEdgeOrdinals(outgoingEdgeMap);
        DagValidator.validateInboundEdgeOrdinals(edges.stream().collect(Collectors.groupingBy(Edge::getDestName)));
        this.detectCycles(outgoingEdgeMap, verticesByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new AnnotatedVertex((Vertex)v.getValue()))));
        return this.topologicalVertexStack;
    }

    private static void validateInboundEdgeOrdinals(Map<String, List<Edge>> incomingEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : incomingEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getDestOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Input ordinals for vertex " + vertex + " are not ordered. " + "Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private static void validateOutboundEdgeOrdinals(Map<String, List<Edge>> outgoingEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : outgoingEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getSourceOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Output ordinals for vertex " + vertex + " are not ordered. " + "Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private void detectCycles(Map<String, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalArgumentException {
        Integer nextIndex = 0;
        ArrayDeque<AnnotatedVertex> stack = new ArrayDeque<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.isEmpty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex);
        }
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<String, List<Edge>> edgeMap, Deque<AnnotatedVertex> stack, Integer nextIndex) throws IllegalArgumentException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        nextIndex = nextIndex + 1;
        Integer n2 = nextIndex;
        stack.addLast(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v.getName());
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v.getName())) {
                AnnotatedVertex outVertex = vertexMap.get(e.getDestName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.removeLast();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getName()).append(" <- ");
                while (pop != av) {
                    message.append(pop.v.getName()).append(" <- ");
                    pop.onstack = false;
                    pop = stack.removeLast();
                }
                message.append(av.v.getName());
                throw new IllegalArgumentException("DAG contains a cycle: " + message);
            }
            if (edgeMap.containsKey(pop.v.getName())) {
                for (Edge edge : edgeMap.get(pop.v.getName())) {
                    if (!edge.getDestName().equals(pop.v.getName())) continue;
                    throw new IllegalArgumentException("DAG contains a self-cycle on vertex:" + pop.v.getName());
                }
            }
            this.topologicalVertexStack.addLast(av.v);
        }
    }

    private static final class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
        }
    }
}

