/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToIntFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.impl.distributed.DistributedComparators;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface DistributedComparator<T>
extends Comparator<T>,
Serializable {
    public static <T extends Comparable<? super T>> DistributedComparator<T> naturalOrder() {
        return DistributedComparators.NATURAL_ORDER_COMPARATOR;
    }

    public static <T extends Comparable<? super T>> DistributedComparator<T> reverseOrder() {
        return DistributedComparators.REVERSE_ORDER_COMPARATOR;
    }

    public static <T> DistributedComparator<T> nullsFirst(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        DistributedComparators.NullComparator c = new DistributedComparators.NullComparator(true);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> DistributedComparator<T> nullsFirst(DistributedComparator<? super T> comparator) {
        return DistributedComparator.nullsFirst(comparator);
    }

    public static <T> DistributedComparator<T> nullsLast(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        DistributedComparators.NullComparator c = new DistributedComparators.NullComparator(false);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> DistributedComparator<T> nullsLast(DistributedComparator<? super T> comparator) {
        return DistributedComparator.nullsLast(comparator);
    }

    public static <T, U> DistributedComparator<T> comparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        Util.checkSerializable(keyExtractor, "keyExtractor");
        Util.checkSerializable(keyComparator, "keyComparator");
        return (c1, c2) -> keyComparator.compare((Object)keyExtractor.apply(c1), (Object)keyExtractor.apply(c2));
    }

    public static <T, U> DistributedComparator<T> comparing(DistributedFunction<? super T, ? extends U> keyExtractor, DistributedComparator<? super U> keyComparator) {
        return DistributedComparator.comparing(keyExtractor, keyComparator);
    }

    public static <T, U extends Comparable<? super U>> DistributedComparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return (c1, c2) -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2));
    }

    public static <T, U extends Comparable<? super U>> DistributedComparator<T> comparing(DistributedFunction<? super T, ? extends U> keyExtractor) {
        return DistributedComparator.comparing(keyExtractor);
    }

    public static <T> DistributedComparator<T> comparingInt(ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return (c1, c2) -> Integer.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2));
    }

    public static <T> DistributedComparator<T> comparingInt(DistributedToIntFunction<? super T> keyExtractor) {
        return DistributedComparator.comparingInt(keyExtractor);
    }

    public static <T> DistributedComparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return (c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
    }

    public static <T> DistributedComparator<T> comparingLong(DistributedToLongFunction<? super T> keyExtractor) {
        return DistributedComparator.comparingLong(keyExtractor);
    }

    public static <T> DistributedComparator<T> comparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return (c1, c2) -> Double.compare(keyExtractor.applyAsDouble(c1), keyExtractor.applyAsDouble(c2));
    }

    public static <T> DistributedComparator<T> comparingDouble(DistributedToDoubleFunction<? super T> keyExtractor) {
        return DistributedComparator.comparingDouble(keyExtractor);
    }

    @Override
    default public DistributedComparator<T> thenComparing(Comparator<? super T> other) {
        Objects.requireNonNull(other);
        Util.checkSerializable(other, "other");
        return (c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    @Override
    default public DistributedComparator<T> thenComparing(DistributedComparator<? super T> other) {
        return this.thenComparing((Comparator)other);
    }

    @Override
    default public <U> DistributedComparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        Util.checkSerializable(keyExtractor, "keyExtractor");
        Util.checkSerializable(keyComparator, "keyComparator");
        return this.thenComparing(DistributedComparator.comparing(keyExtractor, keyComparator));
    }

    @Override
    default public <U> DistributedComparator<T> thenComparing(DistributedFunction<? super T, ? extends U> keyExtractor, DistributedComparator<? super U> keyComparator) {
        return this.thenComparing((Function)keyExtractor, (Comparator)keyComparator);
    }

    @Override
    default public <U extends Comparable<? super U>> DistributedComparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor) {
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return this.thenComparing(DistributedComparator.comparing(keyExtractor));
    }

    @Override
    default public <U extends Comparable<? super U>> DistributedComparator<T> thenComparing(DistributedFunction<? super T, ? extends U> keyExtractor) {
        return this.thenComparing((Function)keyExtractor);
    }

    @Override
    default public DistributedComparator<T> thenComparingInt(ToIntFunction<? super T> keyExtractor) {
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return this.thenComparing(DistributedComparator.comparingInt(keyExtractor));
    }

    @Override
    default public DistributedComparator<T> thenComparingInt(DistributedToIntFunction<? super T> keyExtractor) {
        return this.thenComparingInt((ToIntFunction)keyExtractor);
    }

    @Override
    default public DistributedComparator<T> thenComparingLong(ToLongFunction<? super T> keyExtractor) {
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return this.thenComparing(DistributedComparator.comparingLong(keyExtractor));
    }

    @Override
    default public DistributedComparator<T> thenComparingLong(DistributedToLongFunction<? super T> keyExtractor) {
        return this.thenComparingLong((ToLongFunction)keyExtractor);
    }

    @Override
    default public DistributedComparator<T> thenComparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        Util.checkSerializable(keyExtractor, "keyExtractor");
        return this.thenComparing(DistributedComparator.comparingDouble(keyExtractor));
    }

    @Override
    default public DistributedComparator<T> thenComparingDouble(DistributedToDoubleFunction<? super T> keyExtractor) {
        return this.thenComparingDouble((ToDoubleFunction)keyExtractor);
    }

    @Override
    default public DistributedComparator<T> reversed() {
        return (o1, o2) -> this.compare(o2, o1);
    }
}

