/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.deployment.ResourceKind;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class JobConfig
implements Serializable {
    private final Set<ResourceConfig> resourceConfigs = new HashSet<ResourceConfig>();

    public JobConfig addClass(Class ... classes) {
        Preconditions.checkNotNull(classes, "Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
        return this;
    }

    public JobConfig addJar(URL url) {
        return this.addJar(url, JobConfig.toFilename(url));
    }

    public JobConfig addJar(URL url, String resourceId) {
        return this.add(url, resourceId, ResourceKind.JAR);
    }

    public JobConfig addJar(File file) {
        try {
            return this.addJar(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addJar(File file, String id) {
        try {
            return this.addJar(file.toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addJar(String path) {
        try {
            File file = new File(path);
            return this.addJar(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addJar(String path, String id) {
        try {
            return this.addJar(new File(path).toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(URL url) {
        return this.addResource(url, JobConfig.toFilename(url));
    }

    public JobConfig addResource(URL url, String id) {
        return this.add(url, id, ResourceKind.DATA);
    }

    public JobConfig addResource(File file) {
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(File file, String id) {
        try {
            return this.add(file.toURI().toURL(), id, ResourceKind.DATA);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(String path) {
        File file = new File(path);
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(String path, String id) {
        try {
            return this.addResource(new File(path).toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public Set<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private JobConfig add(URL url, String id, ResourceKind type) {
        this.resourceConfigs.add(new ResourceConfig(url, id, type));
        return this;
    }

    private static String toFilename(URL url) {
        String urlFile = url.getFile();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1, urlFile.length());
    }
}

